/*
 * Decompiled with CFR 0.152.
 */
package org.acme.facilitylocation.solver;

import org.acme.facilitylocation.domain.Consumer;
import org.acme.facilitylocation.domain.Facility;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;

public class FacilityLocationConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.facilityCapacity(constraintFactory), this.setupCost(constraintFactory), this.distanceFromFacility(constraintFactory)};
    }

    Constraint facilityCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Consumer.class).groupBy(Consumer::getFacility, ConstraintCollectors.sumLong(Consumer::getDemand)).filter((facility, demand) -> demand > facility.getCapacity()).penalizeConfigurableLong("facility capacity", (facility, demand) -> demand - facility.getCapacity());
    }

    Constraint setupCost(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Consumer.class).groupBy(Consumer::getFacility).penalizeConfigurableLong("facility setup cost", Facility::getSetupCost);
    }

    Constraint distanceFromFacility(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Consumer.class).filter(Consumer::isAssigned).penalizeConfigurableLong("distance from facility", Consumer::distanceFromFacility);
    }
}

