/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.lookup.ClassAndPlanningIdComparator;
import org.optaplanner.core.impl.domain.lookup.LookUpManager;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerSupport;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirector<Solution_, Score_ extends Score<Score_>, Factory_ extends AbstractScoreDirectorFactory<Solution_, Score_>>
implements InnerScoreDirector<Solution_, Score_>,
Cloneable {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Class, MemberAccessor> planningIdAccessorCacheMap = new HashMap<Class, MemberAccessor>(0);
    protected final Factory_ scoreDirectorFactory;
    protected final boolean lookUpEnabled;
    protected final LookUpManager lookUpManager;
    protected boolean constraintMatchEnabledPreference;
    protected final VariableListenerSupport<Solution_> variableListenerSupport;
    protected Solution_ workingSolution;
    protected long workingEntityListRevision = 0L;
    protected Integer workingInitScore = null;
    protected boolean allChangesWillBeUndoneBeforeStepEnds = false;
    protected long calculationCount = 0L;

    protected AbstractScoreDirector(Factory_ scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.lookUpEnabled = lookUpEnabled;
        this.lookUpManager = lookUpEnabled ? new LookUpManager(((AbstractScoreDirectorFactory)scoreDirectorFactory).getSolutionDescriptor().getLookUpStrategyResolver()) : null;
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
        this.variableListenerSupport = VariableListenerSupport.create(this);
        this.variableListenerSupport.linkVariableListeners();
    }

    public Factory_ getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition<Score_> getScoreDefinition() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getScoreDefinition();
    }

    @Override
    public void overwriteConstraintMatchEnabledPreference(boolean constraintMatchEnabledPreference) {
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
    }

    @Override
    public Solution_ getWorkingSolution() {
        return this.workingSolution;
    }

    @Override
    public long getWorkingEntityListRevision() {
        return this.workingEntityListRevision;
    }

    @Override
    public void setAllChangesWillBeUndoneBeforeStepEnds(boolean allChangesWillBeUndoneBeforeStepEnds) {
        this.allChangesWillBeUndoneBeforeStepEnds = allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public long getCalculationCount() {
        return this.calculationCount;
    }

    @Override
    public void resetCalculationCount() {
        this.calculationCount = 0L;
    }

    @Override
    public SupplyManager getSupplyManager() {
        return this.variableListenerSupport;
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        this.workingSolution = Objects.requireNonNull(workingSolution);
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        this.workingInitScore = -solutionDescriptor.countUninitialized(workingSolution);
        if (this.lookUpEnabled) {
            this.lookUpManager.reset();
            solutionDescriptor.visitAllFacts(workingSolution, c -> {
                this.lookUpManager.addWorkingObject(c);
                this.assertNonNullPlanningId(c);
            });
        } else {
            solutionDescriptor.visitAllFacts(workingSolution, this::assertNonNullPlanningId);
        }
        this.variableListenerSupport.resetWorkingSolution();
        this.setWorkingEntityListDirty();
    }

    @Override
    public void assertNonNullPlanningIds() {
        this.getSolutionDescriptor().visitAllFacts(this.workingSolution, this::assertNonNullPlanningId);
    }

    private void assertNonNullPlanningId(Object fact) {
        MemberAccessor planningIdAccessor;
        Class<?> factClass = fact.getClass();
        if (!this.planningIdAccessorCacheMap.containsKey(factClass)) {
            this.planningIdAccessorCacheMap.put(factClass, ConfigUtils.findPlanningIdMemberAccessor(factClass, this.getSolutionDescriptor().getDomainAccessType(), this.getSolutionDescriptor().getGeneratedMemberAccessorMap()));
        }
        if ((planningIdAccessor = this.planningIdAccessorCacheMap.get(factClass)) == null) {
            return;
        }
        Object id = planningIdAccessor.executeGetter(fact);
        if (id == null) {
            throw new IllegalStateException("The planningId (" + id + ") of the member (" + planningIdAccessor + ") of the class (" + factClass + ") on object (" + fact + ") must not be null.\nMaybe initialize the planningId of the class (" + planningIdAccessor.getDeclaringClass() + ") instance (" + fact + ") before solving.\nMaybe remove the @" + PlanningId.class.getSimpleName() + " annotation.");
        }
    }

    @Override
    public Score_ doAndProcessMove(Move<Solution_> move, boolean assertMoveScoreFromScratch) {
        Move<Solution_> undoMove = move.doMove(this);
        Object score = this.calculateScore();
        if (assertMoveScoreFromScratch) {
            this.assertWorkingScoreFromScratch(score, move);
        }
        undoMove.doMoveOnly(this);
        return score;
    }

    @Override
    public void doAndProcessMove(Move<Solution_> move, boolean assertMoveScoreFromScratch, Consumer<Score_> moveProcessor) {
        Move<Solution_> undoMove = move.doMove(this);
        Object score = this.calculateScore();
        if (assertMoveScoreFromScratch) {
            this.assertWorkingScoreFromScratch(score, move);
        }
        moveProcessor.accept(score);
        undoMove.doMoveOnly(this);
    }

    @Override
    public boolean isWorkingEntityListDirty(long expectedWorkingEntityListRevision) {
        return this.workingEntityListRevision != expectedWorkingEntityListRevision;
    }

    protected void setWorkingEntityListDirty() {
        ++this.workingEntityListRevision;
    }

    @Override
    public Solution_ cloneWorkingSolution() {
        return this.cloneSolution(this.workingSolution);
    }

    @Override
    public Solution_ cloneSolution(Solution_ originalSolution) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        Score originalScore = solutionDescriptor.getScore(originalSolution);
        Solution_ cloneSolution = solutionDescriptor.getSolutionCloner().cloneSolution(originalSolution);
        Score cloneScore = solutionDescriptor.getScore(cloneSolution);
        if (((AbstractScoreDirectorFactory)this.scoreDirectorFactory).isAssertClonedSolution()) {
            if (!Objects.equals(originalScore, cloneScore)) {
                throw new IllegalStateException("Cloning corruption: the original's score (" + originalScore + ") is different from the clone's score (" + cloneScore + ").\nCheck the " + SolutionCloner.class.getSimpleName() + ".");
            }
            IdentityHashMap originalEntityMap = new IdentityHashMap();
            solutionDescriptor.visitAllEntities(originalSolution, originalEntity -> originalEntityMap.put(originalEntity, null));
            solutionDescriptor.visitAllEntities(cloneSolution, cloneEntity -> {
                if (originalEntityMap.containsKey(cloneEntity)) {
                    throw new IllegalStateException("Cloning corruption: the same entity (" + cloneEntity + ") is present in both the original and the clone.\nSo when a planning variable in the original solution changes, the cloned solution will change too.\nCheck the " + SolutionCloner.class.getSimpleName() + ".");
                }
            });
        }
        return cloneSolution;
    }

    @Override
    public void triggerVariableListeners() {
        this.variableListenerSupport.triggerVariableListenersInNotificationQueues();
    }

    protected void setCalculatedScore(Score_ score) {
        this.getSolutionDescriptor().setScore(this.workingSolution, (Score)score);
        ++this.calculationCount;
    }

    public AbstractScoreDirector<Solution_, Score_, Factory_> clone() {
        AbstractScoreDirector clone = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector(this.lookUpEnabled, this.constraintMatchEnabledPreference);
        clone.setWorkingSolution(this.cloneWorkingSolution());
        return clone;
    }

    @Override
    public InnerScoreDirector<Solution_, Score_> createChildThreadScoreDirector(ChildThreadType childThreadType) {
        if (childThreadType == ChildThreadType.PART_THREAD) {
            AbstractScoreDirector childThreadScoreDirector = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector(this.lookUpEnabled, this.constraintMatchEnabledPreference);
            childThreadScoreDirector.calculationCount = this.calculationCount;
            return childThreadScoreDirector;
        }
        if (childThreadType == ChildThreadType.MOVE_THREAD) {
            AbstractScoreDirector childThreadScoreDirector = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector(true, this.constraintMatchEnabledPreference);
            childThreadScoreDirector.setWorkingSolution(this.cloneWorkingSolution());
            return childThreadScoreDirector;
        }
        throw new IllegalStateException("The childThreadType (" + childThreadType + ") is not implemented.");
    }

    @Override
    public void close() {
        this.workingSolution = null;
        this.workingInitScore = null;
        if (this.lookUpEnabled) {
            this.lookUpManager.reset();
        }
        this.variableListenerSupport.close();
    }

    @Override
    public final void beforeEntityAdded(Object entity) {
        this.beforeEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityAdded(Object entity) {
        this.afterEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void beforeVariableChanged(Object entity, String variableName) {
        VariableDescriptor<Solution_> variableDescriptor = this.getSolutionDescriptor().findVariableDescriptorOrFail(entity, variableName);
        this.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final void afterVariableChanged(Object entity, String variableName) {
        VariableDescriptor<Solution_> variableDescriptor = this.getSolutionDescriptor().findVariableDescriptorOrFail(entity, variableName);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final void beforeEntityRemoved(Object entity) {
        this.beforeEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityRemoved(Object entity) {
        this.afterEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.variableListenerSupport.beforeEntityAdded(entityDescriptor, entity);
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore = this.workingInitScore - entityDescriptor.countUninitializedVariables(entity);
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(entity);
        }
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            Integer n = this.workingInitScore;
            Integer n2 = this.workingInitScore = Integer.valueOf(this.workingInitScore + 1);
        }
        this.variableListenerSupport.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            Integer n = this.workingInitScore;
            Integer n2 = this.workingInitScore = Integer.valueOf(this.workingInitScore - 1);
        }
    }

    @Override
    public void changeVariableFacade(VariableDescriptor<Solution_> variableDescriptor, Object entity, Object newValue) {
        this.beforeVariableChanged(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void beforeElementAdded(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
        this.variableListenerSupport.beforeElementAdded(variableDescriptor, entity, index);
    }

    @Override
    public void afterElementAdded(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
        Integer n = this.workingInitScore;
        Integer n2 = this.workingInitScore = Integer.valueOf(this.workingInitScore + 1);
    }

    @Override
    public void beforeElementRemoved(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
        this.variableListenerSupport.beforeElementRemoved(variableDescriptor, entity, index);
    }

    @Override
    public void afterElementRemoved(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
        Integer n = this.workingInitScore;
        Integer n2 = this.workingInitScore = Integer.valueOf(this.workingInitScore - 1);
    }

    @Override
    public void beforeElementMoved(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
        this.variableListenerSupport.beforeElementMoved(variableDescriptor, sourceEntity, sourceIndex, destinationEntity, destinationIndex);
    }

    @Override
    public void afterElementMoved(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore = this.workingInitScore + entityDescriptor.countUninitializedVariables(entity);
        this.variableListenerSupport.beforeEntityRemoved(entityDescriptor, entity);
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(entity);
        }
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public void beforeProblemPropertyChanged(Object problemFactOrEntity) {
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        if (this.isConstraintConfiguration(problemFactOrEntity)) {
            this.setWorkingSolution(this.workingSolution);
        } else {
            this.variableListenerSupport.resetWorkingSolution();
        }
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
        if (this.isConstraintConfiguration(problemFact)) {
            throw new IllegalStateException("Attempted to remove constraint configuration (" + problemFact + ") from solution (" + this.workingSolution + ").\nMaybe use before/afterProblemPropertyChanged(...) instead.");
        }
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public <E> E lookUpWorkingObject(E externalObject) {
        if (!this.lookUpEnabled) {
            throw new IllegalStateException("When lookUpEnabled (" + this.lookUpEnabled + ") is disabled in the constructor, this method should not be called.");
        }
        return this.lookUpManager.lookUpWorkingObject(externalObject);
    }

    @Override
    public <E> E lookUpWorkingObjectOrReturnNull(E externalObject) {
        if (!this.lookUpEnabled) {
            throw new IllegalStateException("When lookUpEnabled (" + this.lookUpEnabled + ") is disabled in the constructor, this method should not be called.");
        }
        return this.lookUpManager.lookUpWorkingObjectOrReturnNull(externalObject);
    }

    @Override
    public void assertExpectedWorkingScore(Score_ expectedWorkingScore, Object completedAction) {
        Object workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new IllegalStateException("Score corruption (" + expectedWorkingScore.subtract(workingScore).toShortString() + "): the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore (" + workingScore + ") after completedAction (" + completedAction + ").");
        }
    }

    @Override
    public void assertShadowVariablesAreNotStale(Score_ expectedWorkingScore, Object completedAction) {
        String violationMessage = this.variableListenerSupport.createShadowVariablesViolationMessage();
        if (violationMessage != null) {
            throw new IllegalStateException(VariableListener.class.getSimpleName() + " corruption after completedAction (" + completedAction + "):\n" + violationMessage);
        }
        Object workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            this.assertWorkingScoreFromScratch(workingScore, "assertShadowVariablesAreNotStale(" + expectedWorkingScore + ", " + completedAction + ")");
            throw new IllegalStateException("Impossible " + VariableListener.class.getSimpleName() + " corruption (" + expectedWorkingScore.subtract(workingScore).toShortString() + "): the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore (" + workingScore + ") after all " + VariableListener.class.getSimpleName() + "s were triggered without changes to the genuine variables after completedAction (" + completedAction + ").\nBut all the shadow variable values are still the same, so this is impossible.\nMaybe run with " + EnvironmentMode.FULL_ASSERT + " if you aren't already, to fail earlier.");
        }
    }

    protected String buildShadowVariableAnalysis(boolean predicted) {
        String workingLabel;
        String violationMessage = this.variableListenerSupport.createShadowVariablesViolationMessage();
        String string = workingLabel = predicted ? "working" : "corrupted";
        if (violationMessage == null) {
            return "Shadow variable corruption in the " + workingLabel + " scoreDirector:\n  None";
        }
        return "Shadow variable corruption in the " + workingLabel + " scoreDirector:\n" + violationMessage + "  Maybe there is a bug in the " + VariableListener.class.getSimpleName() + " of those shadow variable(s).";
    }

    @Override
    public void assertWorkingScoreFromScratch(Score_ workingScore, Object completedAction) {
        this.assertScoreFromScratch(workingScore, completedAction, false);
    }

    @Override
    public void assertPredictedScoreFromScratch(Score_ workingScore, Object completedAction) {
        this.assertScoreFromScratch(workingScore, completedAction, true);
    }

    private void assertScoreFromScratch(Score_ score, Object completedAction, boolean predicted) {
        InnerScoreDirectorFactory assertionScoreDirectorFactory = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory == null) {
            assertionScoreDirectorFactory = this.scoreDirectorFactory;
        }
        try (InnerScoreDirector uncorruptedScoreDirector = assertionScoreDirectorFactory.buildScoreDirector(false, true);){
            uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
            Object uncorruptedScore = uncorruptedScoreDirector.calculateScore();
            if (!score.equals(uncorruptedScore)) {
                String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector, predicted);
                String shadowVariableAnalysis = this.buildShadowVariableAnalysis(predicted);
                throw new IllegalStateException("Score corruption (" + score.subtract(uncorruptedScore).toShortString() + "): the " + (predicted ? "predictedScore" : "workingScore") + " (" + score + ") is not the uncorruptedScore (" + uncorruptedScore + ") after completedAction (" + completedAction + "):\n" + scoreCorruptionAnalysis + "\n" + shadowVariableAnalysis);
            }
        }
    }

    @Override
    public void assertExpectedUndoMoveScore(Move<Solution_> move, Score_ beforeMoveScore) {
        Score_ undoScore = this.calculateScore();
        if (!undoScore.equals(beforeMoveScore)) {
            this.logger.trace("        Corruption detected. Diagnosing...");
            String undoMoveString = "Undo(" + move + ")";
            this.assertWorkingScoreFromScratch(undoScore, undoMoveString);
            this.assertShadowVariablesAreNotStale(undoScore, undoMoveString);
            String scoreDifference = undoScore.subtract(beforeMoveScore).toShortString();
            throw new IllegalStateException("UndoMove corruption (" + scoreDifference + "): the beforeMoveScore (" + beforeMoveScore + ") is not the undoScore (" + undoScore + ") which is the uncorruptedScore (" + undoScore + ") of the workingSolution.\n  1) Enable EnvironmentMode " + EnvironmentMode.FULL_ASSERT + " (if you haven't already) to fail-faster in case there's a score corruption or variable listener corruption.\n  2) Check the Move.createUndoMove(...) method of the moveClass (" + move.getClass() + "). The move (" + move + ") might have a corrupted undoMove (" + undoMoveString + ").\n  3) Check your custom " + VariableListener.class.getSimpleName() + "s (if you have any) for shadow variables that are used by score constraints that could cause the scoreDifference (" + scoreDifference + ").");
        }
    }

    protected String buildScoreCorruptionAnalysis(InnerScoreDirector<Solution_, Score_> uncorruptedScoreDirector, boolean predicted) {
        String workingLabel;
        if (!this.isConstraintMatchEnabled() || !uncorruptedScoreDirector.isConstraintMatchEnabled()) {
            return "Score corruption analysis could not be generated because either corrupted constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") or uncorrupted constraintMatchEnabled (" + uncorruptedScoreDirector.isConstraintMatchEnabled() + ") is disabled.\n  Check your score constraints manually.";
        }
        Map constraintMatchTotalMap = this.getConstraintMatchTotalMap();
        Map corruptedMap = this.createConstraintMatchMap(constraintMatchTotalMap.values());
        Map<String, ConstraintMatchTotal<Score_>> uncorruptedConstraintMatchTotalMap = uncorruptedScoreDirector.getConstraintMatchTotalMap();
        Map<Object, Set<ConstraintMatch<Score_>>> uncorruptedMap = this.createConstraintMatchMap(uncorruptedConstraintMatchTotalMap.values());
        LinkedHashSet excessSet = new LinkedHashSet();
        LinkedHashSet missingSet = new LinkedHashSet();
        uncorruptedMap.forEach((key, uncorruptedMatches) -> {
            Set<ConstraintMatch<Score_>> corruptedMatches = corruptedMap.getOrDefault(key, Collections.emptySet());
            if (corruptedMatches.isEmpty()) {
                missingSet.addAll(uncorruptedMatches);
                return;
            }
            this.updateExcessAndMissingConstraintMatches((Set<ConstraintMatch<Score_>>)uncorruptedMatches, corruptedMatches, excessSet, missingSet);
        });
        corruptedMap.forEach((key, corruptedMatches) -> {
            Set<ConstraintMatch<Score_>> uncorruptedMatches = uncorruptedMap.getOrDefault(key, Collections.emptySet());
            if (uncorruptedMatches.isEmpty()) {
                excessSet.addAll(corruptedMatches);
                return;
            }
            this.updateExcessAndMissingConstraintMatches(uncorruptedMatches, (Set<ConstraintMatch<Score_>>)corruptedMatches, excessSet, missingSet);
        });
        int CONSTRAINT_MATCH_DISPLAY_LIMIT = 8;
        StringBuilder analysis = new StringBuilder();
        analysis.append("Score corruption analysis:\n");
        String string = workingLabel = predicted ? "working" : "corrupted";
        if (excessSet.isEmpty()) {
            analysis.append("  The ").append(workingLabel).append(" scoreDirector has no ConstraintMatch(s) which are in excess.\n");
        } else {
            analysis.append("  The ").append(workingLabel).append(" scoreDirector has ").append(excessSet.size()).append(" ConstraintMatch(s) which are in excess (and should not be there):\n");
            excessSet.stream().sorted().limit(8L).forEach(constraintMatch -> analysis.append("    ").append(constraintMatch).append("\n"));
            if (excessSet.size() >= 8) {
                analysis.append("    ... ").append(excessSet.size() - 8).append(" more\n");
            }
        }
        if (missingSet.isEmpty()) {
            analysis.append("  The ").append(workingLabel).append(" scoreDirector has no ConstraintMatch(s) which are missing.\n");
        } else {
            analysis.append("  The ").append(workingLabel).append(" scoreDirector has ").append(missingSet.size()).append(" ConstraintMatch(s) which are missing:\n");
            missingSet.stream().sorted().limit(8L).forEach(constraintMatch -> analysis.append("    ").append(constraintMatch).append("\n"));
            if (missingSet.size() >= 8) {
                analysis.append("    ... ").append(missingSet.size() - 8).append(" more\n");
            }
        }
        if (!missingSet.isEmpty() || !excessSet.isEmpty()) {
            analysis.append("  Maybe there is a bug in the score constraints of those ConstraintMatch(s).\n");
            analysis.append("  Maybe a score constraint doesn't select all the entities it depends on, but finds some through a reference in a selected entity. This corrupts incremental score calculation, because the constraint is not re-evaluated if such a non-selected entity changes.");
        } else if (predicted) {
            analysis.append("  If multithreaded solving is active, the working scoreDirector is probably not the corrupted scoreDirector.\n");
            analysis.append("  If multithreaded solving is active, maybe the rebase() method of the move is bugged.\n");
            analysis.append("  If multithreaded solving is active, maybe a VariableListener affected the moveThread's workingSolution after doing and undoing a move, but this didn't happen here on the solverThread, so we can't detect it.");
        } else {
            analysis.append("  Impossible state. Maybe this is a bug in the scoreDirector (").append(this.getClass()).append(").");
        }
        return analysis.toString();
    }

    private void updateExcessAndMissingConstraintMatches(Set<ConstraintMatch<Score_>> uncorruptedSet, Set<ConstraintMatch<Score_>> corruptedSet, Set<ConstraintMatch<Score_>> excessSet, Set<ConstraintMatch<Score_>> missingSet) {
        int uncorruptedMatchCount = uncorruptedSet.size();
        int corruptedMatchCount = corruptedSet.size();
        if (corruptedMatchCount > uncorruptedMatchCount) {
            corruptedSet.stream().limit(corruptedMatchCount - uncorruptedMatchCount).forEach(excessSet::add);
        } else if (corruptedMatchCount < uncorruptedMatchCount) {
            uncorruptedSet.stream().limit(uncorruptedMatchCount - corruptedMatchCount).forEach(missingSet::add);
        }
    }

    private Map<Object, Set<ConstraintMatch<Score_>>> createConstraintMatchMap(Collection<ConstraintMatchTotal<Score_>> constraintMatchTotals) {
        ClassAndPlanningIdComparator comparator = new ClassAndPlanningIdComparator(this.getSolutionDescriptor().getDomainAccessType(), this.getSolutionDescriptor().getGeneratedMemberAccessorMap(), false);
        LinkedHashMap<Object, Set<ConstraintMatch<Score_>>> constraintMatchMap = new LinkedHashMap<Object, Set<ConstraintMatch<Score_>>>(constraintMatchTotals.size() * 16);
        for (ConstraintMatchTotal<Score_> constraintMatchTotal : constraintMatchTotals) {
            String constraintId = constraintMatchTotal.getConstraintId();
            for (ConstraintMatch<Score_> constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                Stream.Builder<String> keyStream = Stream.builder().add(constraintId);
                constraintMatch.getJustificationList().stream().sorted(comparator).forEach(keyStream);
                List key = keyStream.add((String)constraintMatch.getScore()).build().collect(Collectors.toList());
                boolean added = constraintMatchMap.computeIfAbsent(key, k -> new LinkedHashSet(0)).add(constraintMatch);
                if (added) continue;
                throw new IllegalStateException("Score corruption because the constraintMatch (" + constraintMatch + ") was added twice for constraintMatchTotal (" + constraintMatchTotal + ") without removal.");
            }
        }
        return constraintMatchMap;
    }

    protected boolean isConstraintConfiguration(Object problemFactOrEntity) {
        SolutionDescriptor solutionDescriptor = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
        ConstraintConfigurationDescriptor constraintConfigurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        if (constraintConfigurationDescriptor == null) {
            return false;
        }
        return constraintConfigurationDescriptor.getConstraintConfigurationClass().isInstance(problemFactOrEntity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.calculationCount + ")";
    }
}

