/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.recaller;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.event.SolverEventSupport;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class BestSolutionRecaller<Solution_>
extends PhaseLifecycleListenerAdapter<Solution_> {
    protected boolean assertInitialScoreFromScratch = false;
    protected boolean assertShadowVariablesAreNotStale = false;
    protected boolean assertBestScoreIsUnmodified = false;
    protected SolverEventSupport<Solution_> solverEventSupport;

    public void setAssertInitialScoreFromScratch(boolean assertInitialScoreFromScratch) {
        this.assertInitialScoreFromScratch = assertInitialScoreFromScratch;
    }

    public void setAssertShadowVariablesAreNotStale(boolean assertShadowVariablesAreNotStale) {
        this.assertShadowVariablesAreNotStale = assertShadowVariablesAreNotStale;
    }

    public void setAssertBestScoreIsUnmodified(boolean assertBestScoreIsUnmodified) {
        this.assertBestScoreIsUnmodified = assertBestScoreIsUnmodified;
    }

    public void setSolverEventSupport(SolverEventSupport<Solution_> solverEventSupport) {
        this.solverEventSupport = solverEventSupport;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        InnerScoreDirector scoreDirector = solverScope.getScoreDirector();
        Object score = scoreDirector.calculateScore();
        solverScope.setBestScore((Score)score);
        solverScope.setBestSolutionTimeMillis(System.currentTimeMillis());
        solverScope.getSolutionDescriptor().setScore(solverScope.getBestSolution(), (Score)score);
        if (score.isSolutionInitialized()) {
            solverScope.setStartingInitializedScore((Score)score);
        } else {
            solverScope.setStartingInitializedScore(null);
        }
        if (this.assertInitialScoreFromScratch) {
            scoreDirector.assertWorkingScoreFromScratch(score, "Initial score calculated");
        }
        if (this.assertShadowVariablesAreNotStale) {
            scoreDirector.assertShadowVariablesAreNotStale(score, "Initial score calculated");
        }
    }

    public void processWorkingSolutionDuringConstructionHeuristicsStep(AbstractStepScope<Solution_> stepScope) {
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        SolverScope<Solution_> solverScope = phaseScope.getSolverScope();
        stepScope.setBestScoreImproved(true);
        phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
        Solution_ newBestSolution = stepScope.getWorkingSolution();
        this.updateBestSolutionWithoutFiring(solverScope, stepScope.getScore(), newBestSolution);
    }

    public void processWorkingSolutionDuringStep(AbstractStepScope<Solution_> stepScope) {
        SolverScope<Solution_> solverScope;
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        Score<?> score = stepScope.getScore();
        boolean bestScoreImproved = score.compareTo((solverScope = phaseScope.getSolverScope()).getBestScore()) > 0;
        stepScope.setBestScoreImproved(bestScoreImproved);
        if (bestScoreImproved) {
            phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution_ newBestSolution = stepScope.createOrGetClonedSolution();
            this.updateBestSolutionAndFire(solverScope, score, newBestSolution);
        } else if (this.assertBestScoreIsUnmodified) {
            solverScope.assertScoreFromScratch(solverScope.getBestSolution());
        }
    }

    public void processWorkingSolutionDuringMove(Score score, AbstractStepScope<Solution_> stepScope) {
        boolean bestScoreImproved;
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        SolverScope<Solution_> solverScope = phaseScope.getSolverScope();
        boolean bl = bestScoreImproved = score.compareTo(solverScope.getBestScore()) > 0;
        if (bestScoreImproved) {
            stepScope.setBestScoreImproved(bestScoreImproved);
        }
        if (bestScoreImproved) {
            phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution_ newBestSolution = solverScope.getScoreDirector().cloneWorkingSolution();
            this.updateBestSolutionAndFire(solverScope, score, newBestSolution);
        } else if (this.assertBestScoreIsUnmodified) {
            solverScope.assertScoreFromScratch(solverScope.getBestSolution());
        }
    }

    public void updateBestSolutionAndFire(SolverScope<Solution_> solverScope) {
        this.updateBestSolutionWithoutFiring(solverScope);
        this.solverEventSupport.fireBestSolutionChanged(solverScope, solverScope.getBestSolution());
    }

    public void updateBestSolutionWithoutFiring(SolverScope<Solution_> solverScope) {
        Solution_ newBestSolution = solverScope.getScoreDirector().cloneWorkingSolution();
        Score newBestScore = solverScope.getSolutionDescriptor().getScore(newBestSolution);
        this.updateBestSolutionWithoutFiring(solverScope, newBestScore, newBestSolution);
    }

    private void updateBestSolutionAndFire(SolverScope<Solution_> solverScope, Score bestScore, Solution_ bestSolution) {
        this.updateBestSolutionWithoutFiring(solverScope, bestScore, bestSolution);
        this.solverEventSupport.fireBestSolutionChanged(solverScope, solverScope.getBestSolution());
    }

    private void updateBestSolutionWithoutFiring(SolverScope<Solution_> solverScope, Score bestScore, Solution_ bestSolution) {
        if (bestScore.isSolutionInitialized() && !solverScope.isBestSolutionInitialized()) {
            solverScope.setStartingInitializedScore(bestScore);
        }
        solverScope.setBestSolution(bestSolution);
        solverScope.setBestScore(bestScore);
        solverScope.setBestSolutionTimeMillis(System.currentTimeMillis());
    }
}

