/*
 * Decompiled with CFR 0.152.
 */
package org.acme.orderpicking.bootstrap;

import io.quarkus.runtime.StartupEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.acme.orderpicking.domain.Order;
import org.acme.orderpicking.domain.OrderItem;
import org.acme.orderpicking.domain.OrderPickingSolution;
import org.acme.orderpicking.domain.Product;
import org.acme.orderpicking.domain.Shelving;
import org.acme.orderpicking.domain.Trolley;
import org.acme.orderpicking.domain.TrolleyStep;
import org.acme.orderpicking.domain.Warehouse;
import org.acme.orderpicking.domain.WarehouseLocation;
import org.acme.orderpicking.persistence.OrderPickingRepository;

@ApplicationScoped
public class DemoDataGenerator {
    private static final int ORDER_ITEMS_SIZE_MINIMUM = 1;
    private static final int TROLLEYS_COUNT = 5;
    private static final int BUCKET_COUNT = 4;
    private static final int BUCKET_CAPACITY = 48000;
    private static final int ORDERS_COUNT = 8;
    private static final WarehouseLocation START_LOCATION = new WarehouseLocation(Shelving.newShelvingId(Warehouse.Column.COL_A, Warehouse.Row.ROW_1), Shelving.Side.LEFT, 0);
    private static final List<ProductFamilyPair> PRODUCTS = List.of(new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Kelloggs Cornflakes", 12600, null), ProductFamily.GENERAL_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Cream Crackers", 322, null), ProductFamily.GENERAL_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Tea Bags 240 packet", 180, null), ProductFamily.GENERAL_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Tomato Soup Can", 1000, null), ProductFamily.GENERAL_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Baked Beans in Tomato Sauce", 1000, null), ProductFamily.GENERAL_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Classic Mint Sauce", 640, null), ProductFamily.GENERAL_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Raspberry Conserve", 640, null), ProductFamily.GENERAL_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Orange Fine Shred Marmalade", 392, null), ProductFamily.GENERAL_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Free Range Eggs 6 Pack", 1200, null), ProductFamily.FRESH_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Mature Cheddar 400G", 450, null), ProductFamily.FRESH_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Butter Packet", 300, null), ProductFamily.FRESH_FOOD), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Iceberg Lettuce Each", 2500, null), ProductFamily.FRUITS_AND_VEGETABLES), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Carrots 1Kg", 1000, null), ProductFamily.FRUITS_AND_VEGETABLES), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Organic Fair Trade Bananas 5 Pack", 1800, null), ProductFamily.FRUITS_AND_VEGETABLES), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Gala Apple Minimum 5 Pack", 5000, null), ProductFamily.FRUITS_AND_VEGETABLES), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Orange Bag 3kg", 8700, null), ProductFamily.FRUITS_AND_VEGETABLES), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Fairy Non Biological Laundry Liquid 4.55L", 5000, null), ProductFamily.HOUSE_CLEANING), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Toilet Tissue 8 Roll White", 20000, null), ProductFamily.HOUSE_CLEANING), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Kitchen Roll 200 Sheets x 2", 13500, null), ProductFamily.HOUSE_CLEANING), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Stainless Steel Cleaner 500Ml", 500, null), ProductFamily.HOUSE_CLEANING), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Antibacterial Surface Spray", 1200, null), ProductFamily.HOUSE_CLEANING), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Beef Lean Steak Mince 500g", 500, null), ProductFamily.MEET_AND_FISH), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Smoked Salmon 120G", 150, null), ProductFamily.MEET_AND_FISH), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Steak Burgers 454G", 450, null), ProductFamily.MEET_AND_FISH), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Pork Cooked Ham 125G", 125, null), ProductFamily.MEET_AND_FISH), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Chicken Breast Fillets 300G", 300, null), ProductFamily.MEET_AND_FISH), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "6 Milk Bricks Pack", 7392, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Milk Brick", 1232, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Skimmed Milk 2.5L", 2500, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "3L Orange Juice", 3000, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Alcohol Free Beer 4 Pack", 13500, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Pepsi Regular Bottle", 1000, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Pepsi Diet 6 x 330ml", 5040, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Schweppes Lemonade 2L", 2000, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Coke Zero 8 x 330ml", 5760, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Natural Mineral Water Still 6 X 1.5Ltr", 9000, null), ProductFamily.DRINKS), new ProductFamilyPair(new Product(DemoDataGenerator.nextId(), "Cocktail Crisps 6 Pack", 2000, null), ProductFamily.SNACKS));
    private static final Map<ProductFamily, List<String>> SHELVINGS_PER_FAMILY = Map.of(ProductFamily.FRUITS_AND_VEGETABLES, List.of(Shelving.newShelvingId(Warehouse.Column.COL_A, Warehouse.Row.ROW_1), Shelving.newShelvingId(Warehouse.Column.COL_A, Warehouse.Row.ROW_2)), ProductFamily.FRESH_FOOD, List.of(Shelving.newShelvingId(Warehouse.Column.COL_A, Warehouse.Row.ROW_3)), ProductFamily.MEET_AND_FISH, List.of(Shelving.newShelvingId(Warehouse.Column.COL_B, Warehouse.Row.ROW_2), Shelving.newShelvingId(Warehouse.Column.COL_B, Warehouse.Row.ROW_3)), ProductFamily.FROZEN_PRODUCTS, List.of(Shelving.newShelvingId(Warehouse.Column.COL_B, Warehouse.Row.ROW_2), Shelving.newShelvingId(Warehouse.Column.COL_B, Warehouse.Row.ROW_1)), ProductFamily.DRINKS, List.of(Shelving.newShelvingId(Warehouse.Column.COL_D, Warehouse.Row.ROW_1)), ProductFamily.SNACKS, List.of(Shelving.newShelvingId(Warehouse.Column.COL_D, Warehouse.Row.ROW_2)), ProductFamily.GENERAL_FOOD, List.of(Shelving.newShelvingId(Warehouse.Column.COL_B, Warehouse.Row.ROW_2), Shelving.newShelvingId(Warehouse.Column.COL_C, Warehouse.Row.ROW_3), Shelving.newShelvingId(Warehouse.Column.COL_D, Warehouse.Row.ROW_2), Shelving.newShelvingId(Warehouse.Column.COL_D, Warehouse.Row.ROW_3)), ProductFamily.HOUSE_CLEANING, List.of(Shelving.newShelvingId(Warehouse.Column.COL_E, Warehouse.Row.ROW_2), Shelving.newShelvingId(Warehouse.Column.COL_E, Warehouse.Row.ROW_1)), ProductFamily.PETS, List.of(Shelving.newShelvingId(Warehouse.Column.COL_E, Warehouse.Row.ROW_3)));
    private static long currentId = 0L;
    @Inject
    OrderPickingRepository orderPickingRepository;
    private final Random random = new Random(37L);

    public void startup(@Observes StartupEvent startupEvent) {
        this.validateBucketCapacity(48000);
        List<Trolley> trolleys = this.buildTrolleys(5, 4, 48000, START_LOCATION);
        List<Order> orders = this.buildOrders(8);
        List<TrolleyStep> trolleySteps = this.buildTrolleySteps(orders);
        this.orderPickingRepository.save(new OrderPickingSolution(trolleys, trolleySteps));
    }

    public List<Order> buildOrders(int size) {
        List<Product> products = this.buildProducts();
        return this.buildOrders(size, products);
    }

    public List<Trolley> buildTrolleys(int size, int bucketCount, int bucketCapacity, WarehouseLocation startLocation) {
        ArrayList<Trolley> result = new ArrayList<Trolley>(size);
        for (int i = 1; i <= size; ++i) {
            result.add(new Trolley(Integer.toString(i), bucketCount, bucketCapacity, startLocation));
        }
        return result;
    }

    public List<TrolleyStep> buildTrolleySteps(List<Order> orders) {
        ArrayList<TrolleyStep> result = new ArrayList<TrolleyStep>();
        for (Order order : orders) {
            result.addAll(this.buildTrolleySteps(order));
        }
        return result;
    }

    public List<TrolleyStep> buildTrolleySteps(Order order) {
        ArrayList<TrolleyStep> steps = new ArrayList<TrolleyStep>();
        for (OrderItem item : order.getItems()) {
            TrolleyStep trolleyStep = new TrolleyStep(item);
            steps.add(trolleyStep);
        }
        return steps;
    }

    public void validateBucketCapacity(int bucketCapacity) {
        if (bucketCapacity < DemoDataGenerator.getMaxProductSize()) {
            throw new IllegalArgumentException("The selected bucketCapacity: " + bucketCapacity + ", is lower than the maximum product size: " + DemoDataGenerator.getMaxProductSize() + ". However for a matter of simplicity the problem was simplified on the assumption that products can always fit in a trolley bucket. Please use a higher value");
        }
    }

    private List<Order> buildOrders(int size, List<Product> products) {
        ArrayList<Order> orderList = new ArrayList<Order>();
        for (int orderNumber = 1; orderNumber <= size; ++orderNumber) {
            int orderItemsSize = 1 + this.random.nextInt(products.size() - 1);
            ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
            HashSet<String> orderProducts = new HashSet<String>();
            Order order = new Order(Integer.toString(orderNumber), orderItems);
            int itemNumber = 1;
            for (int i = 0; i < orderItemsSize; ++i) {
                int productItemIndex = this.random.nextInt(products.size());
                Product product = products.get(productItemIndex);
                if (orderProducts.contains(product.getId())) continue;
                orderItems.add(new OrderItem(Integer.toString(itemNumber++), order, product));
                orderProducts.add(product.getId());
            }
            orderList.add(order);
        }
        return orderList;
    }

    private List<Product> buildProducts() {
        return PRODUCTS.stream().map(productFamilyPair -> {
            List<String> shelvingIds = SHELVINGS_PER_FAMILY.get((Object)productFamilyPair.getFamily());
            int shelvingIndex = this.random.nextInt(shelvingIds.size());
            Shelving.Side shelvingSide = Shelving.Side.values()[this.random.nextInt(Shelving.Side.values().length)];
            int shelvingRow = this.random.nextInt(10) + 1;
            WarehouseLocation warehouseLocation = new WarehouseLocation(shelvingIds.get(shelvingIndex), shelvingSide, shelvingRow);
            return new Product(productFamilyPair.getProduct().getId(), productFamilyPair.getProduct().getName(), productFamilyPair.getProduct().getVolume(), warehouseLocation);
        }).collect(Collectors.toList());
    }

    public static int getMaxProductSize() {
        return PRODUCTS.stream().mapToInt(productFamilyPair -> productFamilyPair.getProduct().getVolume()).max().orElse(0);
    }

    private static String nextId() {
        return String.valueOf(currentId++);
    }

    public static class ProductFamilyPair {
        final Product product;
        final ProductFamily family;

        public ProductFamilyPair(Product product, ProductFamily family) {
            this.product = product;
            this.family = family;
        }

        public Product getProduct() {
            return this.product;
        }

        public ProductFamily getFamily() {
            return this.family;
        }
    }

    public static enum ProductFamily {
        GENERAL_FOOD,
        FRESH_FOOD,
        MEET_AND_FISH,
        FROZEN_PRODUCTS,
        FRUITS_AND_VEGETABLES,
        HOUSE_CLEANING,
        DRINKS,
        SNACKS,
        PETS;

    }
}

