/*
 * Decompiled with CFR 0.152.
 */
package org.acme.orderpicking.domain;

import java.util.HashMap;
import java.util.Map;
import org.acme.orderpicking.domain.OrderPickingSolution;
import org.acme.orderpicking.domain.Trolley;
import org.acme.orderpicking.domain.Warehouse;
import org.optaplanner.core.api.solver.SolverStatus;

public class OrderPickingPlanning {
    private SolverStatus solverStatus;
    private OrderPickingSolution solution;
    private boolean solverWasNeverStarted;
    private Map<String, Integer> distanceToTravelByTrolley = new HashMap<String, Integer>();

    public OrderPickingPlanning() {
    }

    public OrderPickingPlanning(SolverStatus solverStatus, OrderPickingSolution solution, boolean solverWasNeverStarted) {
        this.solverStatus = solverStatus;
        this.solution = solution;
        this.solverWasNeverStarted = solverWasNeverStarted;
        for (Trolley trolley : solution.getTrolleyList()) {
            this.distanceToTravelByTrolley.put(trolley.getId(), Warehouse.calculateDistanceToTravel(trolley));
        }
    }

    public SolverStatus getSolverStatus() {
        return this.solverStatus;
    }

    public OrderPickingSolution getSolution() {
        return this.solution;
    }

    public boolean getSolverWasNeverStarted() {
        return this.solverWasNeverStarted;
    }

    public Map<String, Integer> getDistanceToTravelByTrolley() {
        return this.distanceToTravelByTrolley;
    }
}

