/*
 * Decompiled with CFR 0.152.
 */
package org.acme.orderpicking.domain;

import java.util.HashMap;
import java.util.Map;
import org.acme.orderpicking.domain.Shelving;
import org.acme.orderpicking.domain.Trolley;
import org.acme.orderpicking.domain.TrolleyStep;
import org.acme.orderpicking.domain.WarehouseLocation;

public class Warehouse {
    private static final int SHELVING_WIDTH = 2;
    private static final int SHELVING_HEIGHT = 10;
    private static final int SHELVING_PADDING = 3;
    private static final Map<String, Shelving> SHELVING_MAP = new HashMap<String, Shelving>();
    private static final String SHELVING_NOT_FOUND_ERROR = "Shelving: %s was not found in current Warehouse structure.";

    private Warehouse() {
    }

    public static int calculateDistance(WarehouseLocation start, WarehouseLocation end) {
        int deltaY;
        Shelving startShelving = SHELVING_MAP.get(start.getShelvingId());
        if (startShelving == null) {
            throw new IndexOutOfBoundsException(String.format(SHELVING_NOT_FOUND_ERROR, start.getShelvingId()));
        }
        Shelving endShelving = SHELVING_MAP.get(end.getShelvingId());
        if (endShelving == null) {
            throw new IndexOutOfBoundsException(String.format(SHELVING_NOT_FOUND_ERROR, end.getShelvingId()));
        }
        int deltaX = 0;
        int startX = Warehouse.getAbsoluteX(startShelving, start);
        int startY = Warehouse.getAbsoluteY(startShelving, start);
        int endX = Warehouse.getAbsoluteX(endShelving, end);
        int endY = Warehouse.getAbsoluteY(endShelving, end);
        if (startShelving == endShelving) {
            if (start.getSide() == end.getSide()) {
                deltaY = Math.abs(startY - endY);
            } else {
                deltaX = 2;
                deltaY = Warehouse.calculateBestYDistanceInShelvingRow(start.getRow(), end.getRow());
            }
        } else if (startShelving.getY() == endShelving.getY()) {
            if (Math.abs(startX - endX) == 3) {
                deltaX = 3;
                deltaY = Math.abs(startY - endY);
            } else {
                deltaX = Math.abs(startX - endX);
                deltaY = Warehouse.calculateBestYDistanceInShelvingRow(start.getRow(), end.getRow());
            }
        } else {
            deltaX = Math.abs(startX - endX);
            deltaY = Math.abs(startY - endY);
        }
        return deltaX + deltaY;
    }

    public static int calculateDistanceToTravel(Trolley trolley) {
        int distance = 0;
        WarehouseLocation previousLocation = trolley.getLocation();
        for (TrolleyStep nextElement = trolley.getNextElement(); nextElement != null; nextElement = nextElement.getNextElement()) {
            distance += Warehouse.calculateDistance(previousLocation, nextElement.getLocation());
            previousLocation = nextElement.getLocation();
        }
        return distance += Warehouse.calculateDistance(previousLocation, trolley.getLocation());
    }

    private static int calculateBestYDistanceInShelvingRow(int startY, int endY) {
        int northDirectionDistance = startY + endY;
        int southDirectionDistance = 10 - startY + (10 - endY);
        return Math.min(northDirectionDistance, southDirectionDistance);
    }

    private static int getAbsoluteX(Shelving shelving, WarehouseLocation location) {
        if (location.getSide() == Shelving.Side.LEFT) {
            return shelving.getX();
        }
        return shelving.getX() + 2;
    }

    private static int getAbsoluteY(Shelving shelving, WarehouseLocation location) {
        return shelving.getY() + location.getRow();
    }

    static {
        int shelvingX = 0;
        for (Column col : Column.values()) {
            int shelvingY = 0;
            for (Row row : Row.values()) {
                Shelving shelving = new Shelving(Shelving.newShelvingId(col, row), shelvingX, shelvingY);
                SHELVING_MAP.put(shelving.getId(), shelving);
                shelvingY = shelvingY + 10 + 3;
            }
            shelvingX = shelvingX + 2 + 3;
        }
    }

    public static enum Row {
        ROW_1(1),
        ROW_2(2),
        ROW_3(3);

        private final int rowId;

        private Row(int rowId) {
            this.rowId = rowId;
        }

        public String toString() {
            return Integer.toString(this.rowId);
        }
    }

    public static enum Column {
        COL_A('A'),
        COL_B('B'),
        COL_C('C'),
        COL_D('D'),
        COL_E('E');

        private final char colId;

        private Column(char colId) {
            this.colId = colId;
        }

        public String toString() {
            return Character.toString(this.colId);
        }
    }
}

