/*
 * Decompiled with CFR 0.152.
 */
package org.acme.orderpicking.rest;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.acme.orderpicking.domain.OrderPickingPlanning;
import org.acme.orderpicking.domain.OrderPickingSolution;
import org.acme.orderpicking.persistence.OrderPickingRepository;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;

@Path(value="orderPicking")
@ApplicationScoped
public class OrderPickingSolverResource {
    private static final long PROBLEM_ID = 1L;
    private final AtomicBoolean solverWasNeverStarted = new AtomicBoolean(true);
    @Inject
    SolverManager<OrderPickingSolution, Long> solverManager;
    @Inject
    OrderPickingRepository orderPickingRepository;

    @GET
    public OrderPickingPlanning getBestSolution() {
        OrderPickingSolution solution = this.orderPickingRepository.find();
        SolverStatus solverStatus = this.solverManager.getSolverStatus((Object)1L);
        return new OrderPickingPlanning(solverStatus, solution, this.solverWasNeverStarted.get());
    }

    @POST
    @Path(value="solve")
    public void solve() {
        this.solverWasNeverStarted.set(false);
        this.solverManager.solveAndListen((Object)1L, problemId -> this.orderPickingRepository.find(), this.orderPickingRepository::save);
    }

    @POST
    @Path(value="stopSolving")
    public void stopSolving() {
        this.solverManager.terminateEarly((Object)1L);
    }
}

