/*
 * Decompiled with CFR 0.152.
 */
package org.acme.orderpicking.solver;

import org.acme.orderpicking.domain.TrolleyStep;
import org.acme.orderpicking.domain.Warehouse;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;

public class OrderPickingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.requiredNumberOfBuckets(constraintFactory), this.minimizeDistanceFromPreviousTrolleyStep(constraintFactory), this.minimizeDistanceFromLastTrolleyStepToPathOrigin(constraintFactory), this.minimizeOrderSplitByTrolley(constraintFactory)};
    }

    Constraint requiredNumberOfBuckets(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TrolleyStep.class).groupBy(trolleyStep -> trolleyStep.getTrolley(), trolleyStep -> trolleyStep.getOrderItem().getOrder(), ConstraintCollectors.sum(trolleyStep -> trolleyStep.getOrderItem().getVolume())).groupBy((trolley, order, orderTotalVolume) -> trolley, (trolley, order, orderTotalVolume) -> order, ConstraintCollectors.sum((trolley, order, orderTotalVolume) -> this.calculateOrderRequiredBuckets((int)orderTotalVolume, trolley.getBucketCapacity()))).groupBy((trolley, order, orderTotalBuckets) -> trolley, ConstraintCollectors.sum((trolley, order, orderTotalBuckets) -> orderTotalBuckets)).filter((trolley, trolleyTotalBuckets) -> trolley.getBucketCount() < trolleyTotalBuckets).penalize("Required number of buckets", (Score)HardSoftLongScore.ONE_HARD, (trolley, trolleyTotalBuckets) -> trolleyTotalBuckets - trolley.getBucketCount());
    }

    Constraint minimizeOrderSplitByTrolley(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TrolleyStep.class).groupBy(trolleyStep -> trolleyStep.getOrderItem().getOrder(), ConstraintCollectors.countDistinctLong(TrolleyStep::getTrolley)).penalizeLong("Minimize order split by trolley", (Score)HardSoftLongScore.ONE_SOFT, (order, trolleySpreadCount) -> trolleySpreadCount * 1000L);
    }

    Constraint minimizeDistanceFromPreviousTrolleyStep(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TrolleyStep.class).penalizeLong("Minimize the distance from the previous trolley step", (Score)HardSoftLongScore.ONE_SOFT, trolleyStep -> Warehouse.calculateDistance(trolleyStep.getPreviousElement().getLocation(), trolleyStep.getLocation()));
    }

    Constraint minimizeDistanceFromLastTrolleyStepToPathOrigin(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TrolleyStep.class).filter(TrolleyStep::isLast).penalizeLong("Minimize the distance from last trolley step to the path origin", (Score)HardSoftLongScore.ONE_SOFT, trolleyStep -> Warehouse.calculateDistance(trolleyStep.getLocation(), trolleyStep.getTrolley().getLocation()));
    }

    private int calculateOrderRequiredBuckets(int orderVolume, int bucketVolume) {
        return (orderVolume + (bucketVolume - 1)) / bucketVolume;
    }
}

