/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vaccinationscheduler.domain;

import com.fasterxml.jackson.annotation.JsonIdentityReference;
import java.time.LocalDate;
import org.acme.vaccinationscheduler.domain.Appointment;
import org.acme.vaccinationscheduler.domain.Location;
import org.acme.vaccinationscheduler.domain.VaccinationCenter;
import org.acme.vaccinationscheduler.domain.VaccineType;

public class Person {
    private String id;
    private String name;
    private Location homeLocation;
    private LocalDate birthdate;
    private long priorityRating;
    private int doseNumber;
    @JsonIdentityReference(alwaysAsId=true)
    private VaccineType requiredVaccineType = null;
    @JsonIdentityReference(alwaysAsId=true)
    private VaccineType preferredVaccineType = null;
    @JsonIdentityReference(alwaysAsId=true)
    private VaccinationCenter requiredVaccinationCenter = null;
    @JsonIdentityReference(alwaysAsId=true)
    private VaccinationCenter preferredVaccinationCenter = null;
    private LocalDate readyDate = null;
    private LocalDate idealDate = null;
    private LocalDate dueDate = null;
    private boolean pinned;
    @JsonIdentityReference(alwaysAsId=true)
    private Appointment appointment;

    public Person() {
    }

    public Person(String id, String name, Location homeLocation, LocalDate birthdate, long priorityRating) {
        this(id, name, homeLocation, birthdate, priorityRating, 1, null, null, null, null, null, null, null);
    }

    public Person(String id, String name, Location homeLocation, LocalDate birthdate, long priorityRating, int doseNumber, VaccineType requiredVaccineType, VaccineType preferredVaccineType, VaccinationCenter requiredVaccinationCenter, VaccinationCenter preferredVaccinationCenter, LocalDate readyDate, LocalDate idealDate, LocalDate dueDate) {
        this.id = id;
        this.name = name;
        this.homeLocation = homeLocation;
        this.birthdate = birthdate;
        this.priorityRating = priorityRating;
        this.doseNumber = doseNumber;
        this.requiredVaccineType = requiredVaccineType;
        this.preferredVaccineType = preferredVaccineType;
        this.requiredVaccinationCenter = requiredVaccinationCenter;
        this.preferredVaccinationCenter = preferredVaccinationCenter;
        this.readyDate = readyDate;
        this.idealDate = idealDate;
        this.dueDate = dueDate;
    }

    public String toString() {
        return this.name + "(" + this.id + ")";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Location getHomeLocation() {
        return this.homeLocation;
    }

    public LocalDate getBirthdate() {
        return this.birthdate;
    }

    public long getPriorityRating() {
        return this.priorityRating;
    }

    public int getDoseNumber() {
        return this.doseNumber;
    }

    public VaccineType getRequiredVaccineType() {
        return this.requiredVaccineType;
    }

    public VaccineType getPreferredVaccineType() {
        return this.preferredVaccineType;
    }

    public VaccinationCenter getRequiredVaccinationCenter() {
        return this.requiredVaccinationCenter;
    }

    public VaccinationCenter getPreferredVaccinationCenter() {
        return this.preferredVaccinationCenter;
    }

    public LocalDate getReadyDate() {
        return this.readyDate;
    }

    public LocalDate getIdealDate() {
        return this.idealDate;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public Appointment getAppointment() {
        return this.appointment;
    }

    public void setAppointment(Appointment appointment) {
        this.appointment = appointment;
    }
}

