/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vaccinationscheduler.domain.solver;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.acme.vaccinationscheduler.domain.Appointment;
import org.acme.vaccinationscheduler.domain.Location;
import org.acme.vaccinationscheduler.domain.Person;
import org.acme.vaccinationscheduler.domain.VaccinationCenter;
import org.acme.vaccinationscheduler.domain.VaccinationSchedule;
import org.acme.vaccinationscheduler.domain.VaccineType;
import org.acme.vaccinationscheduler.domain.solver.PersonAssignment;
import org.acme.vaccinationscheduler.domain.solver.VaccinationSlot;
import org.acme.vaccinationscheduler.solver.geo.DistanceCalculator;
import org.acme.vaccinationscheduler.solver.geo.EuclideanDistanceCalculator;
import org.apache.commons.lang3.tuple.Triple;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PlanningSolution
public class VaccinationSolution {
    protected static final Logger logger = LoggerFactory.getLogger(VaccinationSolution.class);
    @ProblemFactCollectionProperty
    private List<VaccineType> vaccineTypeList;
    @ProblemFactCollectionProperty
    private List<VaccinationCenter> vaccinationCenterList;
    private List<Appointment> appointmentList;
    @ProblemFactCollectionProperty
    @ValueRangeProvider(id="vaccinationSlotRange")
    private List<VaccinationSlot> vaccinationSlotList;
    @PlanningEntityCollectionProperty
    private List<PersonAssignment> personAssignmentList;
    @PlanningScore(bendableHardLevelsSize=1, bendableSoftLevelsSize=5)
    private BendableLongScore score;

    public VaccinationSolution() {
    }

    public VaccinationSolution(List<VaccineType> vaccineTypeList, List<VaccinationCenter> vaccinationCenterList, List<Appointment> appointmentList, List<VaccinationSlot> vaccinationSlotList, List<PersonAssignment> personAssignmentList, BendableLongScore score) {
        this.vaccineTypeList = vaccineTypeList;
        this.vaccinationCenterList = vaccinationCenterList;
        this.appointmentList = appointmentList;
        this.vaccinationSlotList = vaccinationSlotList;
        this.personAssignmentList = personAssignmentList;
        this.score = score;
    }

    public VaccinationSolution(VaccinationSchedule schedule) {
        this(schedule, new EuclideanDistanceCalculator());
    }

    public VaccinationSolution(VaccinationSchedule schedule, DistanceCalculator distanceCalculator) {
        this.vaccineTypeList = schedule.getVaccineTypeList();
        this.vaccinationCenterList = schedule.getVaccinationCenterList();
        this.appointmentList = schedule.getAppointmentList();
        Function<Appointment, Triple> tripleFunction = appointment -> Triple.of((Object)appointment.getVaccinationCenter(), (Object)appointment.getDateTime().truncatedTo(ChronoUnit.HOURS), (Object)appointment.getVaccineType());
        Set scheduledAppointmentSet = schedule.getPersonList().stream().map(Person::getAppointment).filter(Objects::nonNull).collect(Collectors.toSet());
        Map appointmentListMap = schedule.getAppointmentList().stream().collect(Collectors.groupingBy(tripleFunction, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), subAppointmentList -> subAppointmentList.stream().sorted(Comparator.comparing(Appointment::getDateTime).thenComparing(Appointment::getBoothId)).collect(Collectors.toList()))));
        this.vaccinationSlotList = new ArrayList<VaccinationSlot>(appointmentListMap.size());
        HashMap<Triple, VaccinationSlot> vaccinationSlotMap = new HashMap<Triple, VaccinationSlot>(appointmentListMap.size());
        long nextVaccinationSlotId = 0L;
        for (Map.Entry entry : appointmentListMap.entrySet()) {
            Triple triple = (Triple)entry.getKey();
            List appointmentList = (List)entry.getValue();
            VaccinationCenter vaccinationCenter = (VaccinationCenter)triple.getLeft();
            LocalDateTime startDateTime = (LocalDateTime)triple.getMiddle();
            VaccineType vaccineType = (VaccineType)triple.getRight();
            List<Appointment> unscheduledAppointmentList = appointmentList.stream().filter(appointment -> !scheduledAppointmentSet.contains(appointment)).collect(Collectors.toList());
            int capacity = appointmentList.size();
            VaccinationSlot vaccinationSlot = new VaccinationSlot(nextVaccinationSlotId++, vaccinationCenter, startDateTime, vaccineType, unscheduledAppointmentList, capacity);
            this.vaccinationSlotList.add(vaccinationSlot);
            vaccinationSlotMap.put(triple, vaccinationSlot);
        }
        List<Person> personList = schedule.getPersonList();
        this.personAssignmentList = new ArrayList<PersonAssignment>(personList.size());
        Location[] fromLocations = (Location[])personList.stream().map(Person::getHomeLocation).toArray(Location[]::new);
        Location[] toLocations = (Location[])this.vaccinationCenterList.stream().map(VaccinationCenter::getLocation).toArray(Location[]::new);
        long[][] distanceMatrix = distanceCalculator.calculateBulkDistance(fromLocations, toLocations);
        for (int personIndex = 0; personIndex < personList.size(); ++personIndex) {
            Person person = personList.get(personIndex);
            HashMap<VaccinationCenter, Long> distanceMap = new HashMap<VaccinationCenter, Long>(this.vaccinationCenterList.size());
            for (int vaccinationCenterIndex = 0; vaccinationCenterIndex < this.vaccinationCenterList.size(); ++vaccinationCenterIndex) {
                VaccinationCenter vaccinationCenter = this.vaccinationCenterList.get(vaccinationCenterIndex);
                long distance = distanceMatrix[personIndex][vaccinationCenterIndex];
                distanceMap.put(vaccinationCenter, distance);
            }
            PersonAssignment personAssignment = new PersonAssignment(person, distanceMap);
            Appointment appointment2 = person.getAppointment();
            if (appointment2 != null) {
                VaccinationSlot vaccinationSlot = (VaccinationSlot)vaccinationSlotMap.get(tripleFunction.apply(appointment2));
                if (vaccinationSlot == null) {
                    throw new IllegalStateException("The person (" + person + ") has a pre-set appointment (" + appointment2 + ") that is not part of the schedule's appointmentList with size (" + schedule.getAppointmentList().size() + ")");
                }
                personAssignment.setVaccinationSlot(vaccinationSlot);
            }
            this.personAssignmentList.add(personAssignment);
        }
        this.score = schedule.getScore();
    }

    public VaccinationSchedule toSchedule() {
        Map<VaccinationSlot, List> appointmentListMap = this.vaccinationSlotList.stream().collect(Collectors.toMap(vaccinationSlot -> vaccinationSlot, vaccinationSlot -> new ArrayList<Appointment>(vaccinationSlot.getUnscheduledAppointmentList())));
        ArrayList<Person> personList = new ArrayList<Person>(this.personAssignmentList.size());
        for (PersonAssignment personAssignment : this.personAssignmentList) {
            Person person = personAssignment.getPerson();
            if (!person.isPinned()) {
                Appointment appointment;
                VaccinationSlot vaccinationSlot2 = personAssignment.getVaccinationSlot();
                if (vaccinationSlot2 == null) {
                    appointment = null;
                } else {
                    List appointmentList = appointmentListMap.get(vaccinationSlot2);
                    if (appointmentList.isEmpty()) {
                        logger.error("The solution is infeasible: the person (" + personAssignment + ") is assigned to vaccinationSlot (" + vaccinationSlot2 + ") but all the appointments are already taken, so leaving that person unassigned.\nImpossible situation: even if the problem has no feasible solution, the capacity hard constraint should force the all-but-one person to remain unassigned because the planning variable has nullable=true.");
                        appointment = null;
                    } else {
                        appointment = (Appointment)appointmentList.remove(0);
                    }
                }
                person.setAppointment(appointment);
            }
            personList.add(person);
        }
        VaccinationSchedule schedule = new VaccinationSchedule(this.vaccineTypeList, this.vaccinationCenterList, this.appointmentList, personList);
        schedule.setScore(this.score);
        return schedule;
    }

    public List<VaccineType> getVaccineTypeList() {
        return this.vaccineTypeList;
    }

    public List<VaccinationCenter> getVaccinationCenterList() {
        return this.vaccinationCenterList;
    }

    public List<Appointment> getAppointmentList() {
        return this.appointmentList;
    }

    public List<VaccinationSlot> getVaccinationSlotList() {
        return this.vaccinationSlotList;
    }

    public void setVaccinationSlotList(List<VaccinationSlot> vaccinationSlotList) {
        this.vaccinationSlotList = vaccinationSlotList;
    }

    public List<PersonAssignment> getPersonAssignmentList() {
        return this.personAssignmentList;
    }

    public BendableLongScore getScore() {
        return this.score;
    }
}

