/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vaccinationscheduler.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.acme.vaccinationscheduler.domain.Appointment;
import org.acme.vaccinationscheduler.domain.Person;
import org.acme.vaccinationscheduler.domain.VaccinationCenter;
import org.acme.vaccinationscheduler.domain.VaccinationSchedule;
import org.acme.vaccinationscheduler.domain.VaccineType;
import org.acme.vaccinationscheduler.domain.solver.VaccinationSolution;
import org.acme.vaccinationscheduler.persistence.VaccinationScheduleRepository;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;

@Path(value="vaccinationSchedule")
public class VaccinationScheduleSolverResource {
    private static final int APPOINTMENT_PAGE_LIMIT = 5000;
    @Inject
    VaccinationScheduleRepository vaccinationScheduleRepository;
    @Inject
    SolverManager<VaccinationSolution, Long> solverManager;

    @GET
    public VaccinationSchedule get(@QueryParam(value="page") Integer page) {
        SolverStatus solverStatus = this.getSolverStatus();
        VaccinationSchedule schedule = this.vaccinationScheduleRepository.find();
        schedule.setSolverStatus(solverStatus);
        if (page != null) {
            if (page < 0) {
                throw new IllegalArgumentException("Unsupported page (" + page + ").");
            }
            int appointmentListSize = schedule.getAppointmentList().size();
            if (appointmentListSize > 5000) {
                List<Person> personList;
                List<Appointment> appointmentList;
                List<VaccineType> vaccineTypeList = schedule.getVaccineTypeList();
                List<VaccinationCenter> vaccinationCenterList = schedule.getVaccinationCenterList();
                if (appointmentListSize <= 5000) {
                    appointmentList = schedule.getAppointmentList();
                    personList = schedule.getPersonList();
                } else {
                    HashMap<VaccinationCenter, Set> boothIdSetMap = new HashMap<VaccinationCenter, Set>(vaccinationCenterList.size());
                    for (VaccinationCenter vaccinationCenter2 : vaccinationCenterList) {
                        boothIdSetMap.put(vaccinationCenter2, new LinkedHashSet());
                    }
                    for (Appointment appointment2 : schedule.getAppointmentList()) {
                        Set boothIdSet2 = (Set)boothIdSetMap.get(appointment2.getVaccinationCenter());
                        boothIdSet2.add(appointment2.getBoothId());
                    }
                    HashMap subBoothIdSetMap = new HashMap(vaccinationCenterList.size());
                    boothIdSetMap.forEach((vaccinationCenter, boothIdSet) -> {
                        ArrayList boothIdList = new ArrayList(boothIdSet);
                        int pageLength = Math.max(1, boothIdList.size() * 5000 / appointmentListSize);
                        subBoothIdSetMap.put(vaccinationCenter, new HashSet(boothIdList.subList(page * pageLength, Math.min(boothIdList.size(), (page + 1) * pageLength))));
                    });
                    appointmentList = schedule.getAppointmentList().stream().filter(appointment -> ((Set)subBoothIdSetMap.get(appointment.getVaccinationCenter())).contains(appointment.getBoothId())).collect(Collectors.toList());
                    personList = schedule.getPersonList().stream().filter(person -> person.getAppointment() != null && ((Set)subBoothIdSetMap.get(person.getAppointment().getVaccinationCenter())).contains(person.getAppointment().getBoothId())).collect(Collectors.toList());
                    List unassignedPersonList = personList.stream().filter(person -> person.getAppointment() == null).collect(Collectors.toList());
                    int pageLength = unassignedPersonList.size() * 5000 / appointmentListSize;
                    personList.addAll(unassignedPersonList.subList(page * pageLength, Math.min(unassignedPersonList.size(), (page + 1) * pageLength)));
                }
                VaccinationSchedule pagedSchedule = new VaccinationSchedule(vaccineTypeList, vaccinationCenterList, appointmentList, personList);
                pagedSchedule.setScore(schedule.getScore());
                pagedSchedule.setSolverStatus(schedule.getSolverStatus());
                return pagedSchedule;
            }
        }
        return schedule;
    }

    @POST
    @Path(value="solve")
    public void solve() {
        this.solverManager.solveAndListen((Object)1L, problemId -> {
            VaccinationSchedule schedule = this.vaccinationScheduleRepository.find();
            return new VaccinationSolution(schedule);
        }, vaccinationSolution -> this.vaccinationScheduleRepository.save(vaccinationSolution.toSchedule()));
    }

    public SolverStatus getSolverStatus() {
        return this.solverManager.getSolverStatus((Object)1L);
    }

    @POST
    @Path(value="stopSolving")
    public void stopSolving() {
        this.solverManager.terminateEarly((Object)1L);
    }
}

