/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vaccinationscheduler.solver;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.acme.vaccinationscheduler.domain.solver.PersonAssignment;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;

public class VaccinationScheduleConstraintProvider
implements ConstraintProvider {
    public static final int HARD_LEVELS_SIZE = 1;
    public static final int SOFT_LEVELS_SIZE = 5;
    private static final LocalDateTime COVID_EPOCH = LocalDateTime.of(2021, 1, 1, 0, 0);

    private BendableLongScore ofHard(long hardScore) {
        return BendableLongScore.ofHard((int)1, (int)5, (int)0, (long)hardScore);
    }

    private BendableLongScore ofSoft(int softLevel, long softScore) {
        return BendableLongScore.ofSoft((int)1, (int)5, (int)softLevel, (long)softScore);
    }

    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.vaccinationSlotCapacity(constraintFactory), this.requiredVaccineType(constraintFactory), this.requiredVaccinationCenter(constraintFactory), this.minimumAgeVaccineType(constraintFactory), this.maximumAgeVaccineType(constraintFactory), this.readyDate(constraintFactory), this.dueDate(constraintFactory), this.scheduleSecondOrLaterDosePeople(constraintFactory), this.scheduleHigherPriorityRatingPeople(constraintFactory), this.preferredVaccineType(constraintFactory), this.preferredVaccinationCenter(constraintFactory), this.regretDistance(constraintFactory), this.idealDate(constraintFactory), this.higherPriorityRatingEarlier(constraintFactory)};
    }

    Constraint vaccinationSlotCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).groupBy(PersonAssignment::getVaccinationSlot, ConstraintCollectors.count()).filter((vaccinationSlot, personCount) -> personCount > vaccinationSlot.getCapacity()).penalizeLong("Vaccination slot capacity", (Score)this.ofHard(1000L), (vaccinationSlot, personCount) -> personCount - vaccinationSlot.getCapacity());
    }

    Constraint requiredVaccineType(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).filter(personAssignment -> personAssignment.getRequiredVaccineType() != null && personAssignment.getVaccinationSlot().getVaccineType() != personAssignment.getRequiredVaccineType()).penalize("Required vaccine type", (Score)this.ofHard(10000000L));
    }

    Constraint requiredVaccinationCenter(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).filter(personAssignment -> personAssignment.getRequiredVaccinationCenter() != null && personAssignment.getVaccinationSlot().getVaccinationCenter() != personAssignment.getRequiredVaccinationCenter()).penalize("Required vaccination center", (Score)this.ofHard(1000000L));
    }

    Constraint minimumAgeVaccineType(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).filter(personAssignment -> personAssignment.getVaccinationSlot().getVaccineType().getMaximumAge() != null && personAssignment.getAgeOnVaccinationDate() < (long)personAssignment.getVaccinationSlot().getVaccineType().getMinimumAge().intValue() && personAssignment.getRequiredVaccineType() == null).penalizeLong("Minimum age of vaccination type", (Score)this.ofHard(1L), personAssignment -> (long)personAssignment.getVaccinationSlot().getVaccineType().getMinimumAge().intValue() - personAssignment.getAgeOnVaccinationDate());
    }

    Constraint maximumAgeVaccineType(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).filter(personAssignment -> personAssignment.getVaccinationSlot().getVaccineType().getMaximumAge() != null && personAssignment.getAgeOnVaccinationDate() > (long)personAssignment.getVaccinationSlot().getVaccineType().getMaximumAge().intValue() && personAssignment.getRequiredVaccineType() == null).penalizeLong("Maximum age of vaccination type", (Score)this.ofHard(1L), personAssignment -> personAssignment.getAgeOnVaccinationDate() - (long)personAssignment.getVaccinationSlot().getVaccineType().getMaximumAge().intValue());
    }

    Constraint readyDate(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).filter(personAssignment -> personAssignment.getReadyDate() != null && personAssignment.getVaccinationSlot().getDate().compareTo(personAssignment.getReadyDate()) < 0).penalizeLong("Ready date", (Score)this.ofHard(1L), personAssignment -> ChronoUnit.DAYS.between(personAssignment.getVaccinationSlot().getDate(), personAssignment.getReadyDate()));
    }

    Constraint dueDate(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).filter(personAssignment -> personAssignment.getDueDate() != null && personAssignment.getVaccinationSlot().getDate().compareTo(personAssignment.getDueDate()) > 0).penalizeLong("Due date", (Score)this.ofHard(1L), personAssignment -> ChronoUnit.DAYS.between(personAssignment.getDueDate(), personAssignment.getVaccinationSlot().getDate()));
    }

    Constraint scheduleSecondOrLaterDosePeople(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(PersonAssignment.class).filter(personAssignment -> personAssignment.getDoseNumber() > 1 && personAssignment.getVaccinationSlot() == null).penalizeLong("Schedule second (or later) dose people", (Score)this.ofSoft(0, 1L), personAssignment -> personAssignment.getDoseNumber() - 1);
    }

    Constraint scheduleHigherPriorityRatingPeople(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(PersonAssignment.class).filter(personAssignment -> personAssignment.getVaccinationSlot() == null).penalizeLong("Schedule higher priority rating people", (Score)this.ofSoft(1, 1L), PersonAssignment::getPriorityRating);
    }

    Constraint preferredVaccineType(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).filter(personAssignment -> personAssignment.getPreferredVaccineType() != null && personAssignment.getVaccinationSlot().getVaccineType() != personAssignment.getPreferredVaccineType()).penalize("Preferred vaccine type", (Score)this.ofSoft(2, 1000000000L));
    }

    Constraint preferredVaccinationCenter(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).filter(personAssignment -> personAssignment.getPreferredVaccinationCenter() != null && personAssignment.getVaccinationSlot().getVaccinationCenter() != personAssignment.getPreferredVaccinationCenter()).penalize("Preferred vaccination center", (Score)this.ofSoft(2, 1000000000L));
    }

    Constraint regretDistance(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).penalizeLong("Regret distance cost", (Score)this.ofSoft(2, 1L), personAssignment -> {
            long regretDistance = personAssignment.getRegretDistanceTo(personAssignment.getVaccinationSlot().getVaccinationCenter());
            return regretDistance * regretDistance;
        });
    }

    Constraint idealDate(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).filter(personAssignment -> personAssignment.getIdealDate() != null && !personAssignment.getIdealDate().equals(personAssignment.getVaccinationSlot().getDate())).penalizeLong("Ideal date", (Score)this.ofSoft(3, 1L), personAssignment -> {
            long daysDiff = ChronoUnit.DAYS.between(personAssignment.getIdealDate(), personAssignment.getVaccinationSlot().getDate());
            return daysDiff * daysDiff;
        });
    }

    Constraint higherPriorityRatingEarlier(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PersonAssignment.class).penalizeLong("Higher priority rating earlier", (Score)this.ofSoft(4, 1L), personAssignment -> personAssignment.getPriorityRating() * ChronoUnit.MINUTES.between(COVID_EPOCH, personAssignment.getVaccinationSlot().getStartDateTime()));
    }
}

