/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vaccinationscheduler.solver.geo;

import org.acme.vaccinationscheduler.domain.Location;
import org.acme.vaccinationscheduler.solver.geo.DistanceCalculator;

public class EuclideanDistanceCalculator
implements DistanceCalculator {
    public static final double METERS_PER_DEGREE = 111000.0;

    @Override
    public long calculateDistance(Location from, Location to) {
        if (from.equals(to)) {
            return 0L;
        }
        double latitudeDiff = to.latitude - from.latitude;
        double longitudeDiff = to.longitude - from.longitude;
        return (long)Math.ceil(Math.sqrt(latitudeDiff * latitudeDiff + longitudeDiff * longitudeDiff) * 111000.0);
    }
}

