/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vaccinationscheduler.solver.optional;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.acme.vaccinationscheduler.domain.VaccinationCenter;
import org.acme.vaccinationscheduler.domain.VaccineType;
import org.acme.vaccinationscheduler.domain.solver.PersonAssignment;
import org.acme.vaccinationscheduler.domain.solver.VaccinationSlot;
import org.acme.vaccinationscheduler.domain.solver.VaccinationSolution;
import org.acme.vaccinationscheduler.solver.PersonAssignmentDifficultyComparator;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.phase.custom.CustomPhaseCommand;

public class VaccinationCustomConstructionHeuristic
implements CustomPhaseCommand<VaccinationSolution> {
    public void changeWorkingSolution(ScoreDirector<VaccinationSolution> scoreDirector) {
        VaccinationSolution schedule = (VaccinationSolution)scoreDirector.getWorkingSolution();
        Map vaccinationCenterToSlotMap = schedule.getVaccinationSlotList().stream().sorted(Comparator.comparing(vaccinationSlot -> vaccinationSlot.getVaccineType().getName()).thenComparing(VaccinationSlot::getDate).thenComparing(VaccinationSlot::getStartTime)).collect(Collectors.groupingBy(VaccinationSlot::getVaccinationCenter, LinkedHashMap::new, Collectors.groupingBy(VaccinationSlot::getVaccineType, LinkedHashMap::new, Collectors.groupingBy(VaccinationSlot::getDate, LinkedHashMap::new, Collectors.toMap(vaccinationSlot -> vaccinationSlot, VaccinationSlot::getCapacity, (key, value) -> {
            throw new IllegalStateException("Duplicate key (" + key + ").");
        }, LinkedHashMap::new)))));
        schedule.getPersonAssignmentList().stream().filter(person -> person.getVaccinationSlot() != null).forEach(person -> {
            VaccinationSlot vaccinationSlot = person.getVaccinationSlot();
            VaccinationCenter vaccinationCenter = vaccinationSlot.getVaccinationCenter();
            Map vaccineTypeToSlotMap = (Map)vaccinationCenterToSlotMap.get(vaccinationCenter);
            VaccineType vaccineType = vaccinationSlot.getVaccineType();
            Map dateToSlotMap = (Map)vaccineTypeToSlotMap.get(vaccineType);
            LocalDate date = vaccinationSlot.getDate();
            Map slotToAvailabilityMap = (Map)dateToSlotMap.get(date);
            int availability = (Integer)slotToAvailabilityMap.get(vaccinationSlot);
            this.reduceAvailability(vaccinationCenterToSlotMap, vaccinationCenter, vaccineTypeToSlotMap, vaccineType, dateToSlotMap, date, slotToAvailabilityMap, vaccinationSlot, availability);
        });
        List personList = schedule.getPersonAssignmentList().stream().filter(person -> !person.isPinned() && person.getVaccinationSlot() == null).sorted(new PersonAssignmentDifficultyComparator().reversed()).collect(Collectors.toList());
        for (PersonAssignment person2 : personList) {
            VaccinationSlot vaccinationSlot2 = this.findAvailableVaccinationSlot(scoreDirector, vaccinationCenterToSlotMap, person2);
            if (vaccinationSlot2 == null) continue;
            scoreDirector.beforeVariableChanged((Object)person2, "vaccinationSlot");
            person2.setVaccinationSlot(vaccinationSlot2);
            scoreDirector.afterVariableChanged((Object)person2, "vaccinationSlot");
            scoreDirector.triggerVariableListeners();
        }
    }

    private VaccinationSlot findAvailableVaccinationSlot(ScoreDirector<VaccinationSolution> scoreDirector, Map<VaccinationCenter, Map<VaccineType, Map<LocalDate, Map<VaccinationSlot, Integer>>>> vaccinationCenterToSlotMap, PersonAssignment person) {
        List vaccinationCenterList = vaccinationCenterToSlotMap.keySet().stream().sorted(Comparator.comparing(vaccinationCenter -> person.getRequiredVaccinationCenter() != vaccinationCenter).thenComparing(vaccinationCenter -> person.getPreferredVaccinationCenter() != vaccinationCenter).thenComparing(person::getDistanceTo)).collect(Collectors.toList());
        for (VaccinationCenter vaccinationCenter2 : vaccinationCenterList) {
            Map<VaccineType, Map<LocalDate, Map<VaccinationSlot, Integer>>> vaccineTypeToSlotMap = vaccinationCenterToSlotMap.get(vaccinationCenter2);
            for (Map.Entry<VaccineType, Map<LocalDate, Map<VaccinationSlot, Integer>>> vaccineTypeEntry : vaccineTypeToSlotMap.entrySet()) {
                VaccineType vaccineType = vaccineTypeEntry.getKey();
                if (person.getRequiredVaccineType() != null && person.getRequiredVaccineType() != vaccineType) {
                    if (!person.getRequiredVaccineType().getName().equals(vaccineType.getName())) continue;
                    throw new IllegalStateException("Don't have 2 VaccineType with the same name (" + vaccineType.getName() + ") instances in your input data.");
                }
                Map<LocalDate, Map<VaccinationSlot, Integer>> dateToSlotMap = vaccineTypeEntry.getValue();
                List dateList = dateToSlotMap.keySet().stream().filter(date -> {
                    long age = ChronoUnit.YEARS.between(person.getBirthdate(), (Temporal)date);
                    if (vaccineType.getMinimumAge() != null && age < (long)vaccineType.getMinimumAge().intValue()) {
                        return false;
                    }
                    if (vaccineType.getMaximumAge() != null && age > (long)vaccineType.getMaximumAge().intValue()) {
                        return false;
                    }
                    if (person.getReadyDate() != null && date.compareTo(person.getReadyDate()) < 0) {
                        return false;
                    }
                    return person.getDueDate() == null || date.compareTo(person.getDueDate()) <= 0;
                }).sorted(person.getIdealDate() == null ? Comparator.naturalOrder() : Comparator.comparing(date -> Math.abs(ChronoUnit.DAYS.between(person.getIdealDate(), (Temporal)date)))).collect(Collectors.toList());
                for (LocalDate date2 : dateList) {
                    Map<VaccinationSlot, Integer> slotToAvailabilityMap = dateToSlotMap.get(date2);
                    Iterator<Map.Entry<VaccinationSlot, Integer>> iterator = slotToAvailabilityMap.entrySet().iterator();
                    if (!iterator.hasNext()) continue;
                    Map.Entry<VaccinationSlot, Integer> slotEntry = iterator.next();
                    VaccinationSlot vaccinationSlot = slotEntry.getKey();
                    int availability = slotEntry.getValue();
                    this.reduceAvailability(vaccinationCenterToSlotMap, vaccinationCenter2, vaccineTypeToSlotMap, vaccineType, dateToSlotMap, date2, slotToAvailabilityMap, vaccinationSlot, availability);
                    return vaccinationSlot;
                }
            }
        }
        return null;
    }

    private void reduceAvailability(Map<VaccinationCenter, Map<VaccineType, Map<LocalDate, Map<VaccinationSlot, Integer>>>> vaccinationCenterToSlotMap, VaccinationCenter vaccinationCenter, Map<VaccineType, Map<LocalDate, Map<VaccinationSlot, Integer>>> vaccineTypeToSlotMap, VaccineType vaccineType, Map<LocalDate, Map<VaccinationSlot, Integer>> dateToSlotMap, LocalDate date, Map<VaccinationSlot, Integer> slotToAvailabilityMap, VaccinationSlot vaccinationSlot, int availability) {
        slotToAvailabilityMap.put(vaccinationSlot, --availability);
        if (availability == 0) {
            slotToAvailabilityMap.remove(vaccinationSlot);
            if (slotToAvailabilityMap.isEmpty()) {
                dateToSlotMap.remove(date);
                if (dateToSlotMap.isEmpty()) {
                    vaccineTypeToSlotMap.remove(vaccineType);
                    if (vaccineTypeToSlotMap.isEmpty()) {
                        vaccinationCenterToSlotMap.remove(vaccinationCenter);
                    }
                }
            }
        }
    }
}

