/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.definition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GenericTypeDefinition
implements Serializable {
    private final String rawType;
    private final List<GenericTypeDefinition> genericTypes;

    public GenericTypeDefinition(String rawType) {
        this(rawType, null);
    }

    private GenericTypeDefinition(String rawType, List<GenericTypeDefinition> genericTypes) {
        this.rawType = rawType;
        this.genericTypes = genericTypes;
    }

    public static GenericTypeDefinition parseType(String type, Function<String, String> resolver) {
        int genericsStart = type.indexOf(60);
        if (genericsStart < 0) {
            String resolvedType = resolver.apply(type);
            return resolvedType != null ? new GenericTypeDefinition(resolvedType, null) : null;
        }
        ArrayList<GenericTypeDefinition> genericTypes = new ArrayList<GenericTypeDefinition>();
        String rawType = type.substring(0, genericsStart).trim();
        String resolvedRawType = resolver.apply(rawType);
        if (resolvedRawType == null) {
            return null;
        }
        String generics = type.substring(genericsStart + 1, type.length() - 1);
        for (String gen : generics.split("\\,")) {
            GenericTypeDefinition genType = GenericTypeDefinition.parseType(gen, resolver);
            if (genType == null) {
                return null;
            }
            genericTypes.add(genType);
        }
        return new GenericTypeDefinition(resolvedRawType, genericTypes);
    }

    public String getRawType() {
        return this.rawType;
    }

    public List<GenericTypeDefinition> getGenericTypes() {
        return this.genericTypes;
    }

    public boolean hasGenerics() {
        return this.genericTypes != null;
    }

    public GenericTypeDefinition map(Function<String, String> transformer) {
        return new GenericTypeDefinition(transformer.apply(this.rawType), this.genericTypes != null ? this.genericTypes.stream().map((? super T t) -> t.map(transformer)).collect(Collectors.toList()) : null);
    }

    public String toString() {
        return this.rawType + (this.genericTypes == null ? "" : "<" + this.genericTypes.stream().map(GenericTypeDefinition::toString).collect(Collectors.joining(", ")) + ">");
    }
}

