/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vehiclerouting.domain;

import java.util.Arrays;
import java.util.List;
import org.acme.vehiclerouting.bootstrap.DemoDataBuilder;
import org.acme.vehiclerouting.domain.Customer;
import org.acme.vehiclerouting.domain.Depot;
import org.acme.vehiclerouting.domain.Location;
import org.acme.vehiclerouting.domain.Vehicle;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;

@PlanningSolution
public class VehicleRoutingSolution {
    private String name;
    @ProblemFactCollectionProperty
    private List<Location> locationList;
    @ProblemFactCollectionProperty
    private List<Depot> depotList;
    @PlanningEntityCollectionProperty
    private List<Vehicle> vehicleList;
    @ProblemFactCollectionProperty
    @ValueRangeProvider(id="customerRange")
    private List<Customer> customerList;
    @PlanningScore
    private HardSoftLongScore score;
    private Location southWestCorner;
    private Location northEastCorner;

    public VehicleRoutingSolution() {
    }

    public VehicleRoutingSolution(String name, List<Location> locationList, List<Depot> depotList, List<Vehicle> vehicleList, List<Customer> customerList, Location southWestCorner, Location northEastCorner) {
        this.name = name;
        this.locationList = locationList;
        this.depotList = depotList;
        this.vehicleList = vehicleList;
        this.customerList = customerList;
        this.southWestCorner = southWestCorner;
        this.northEastCorner = northEastCorner;
    }

    public static VehicleRoutingSolution empty() {
        VehicleRoutingSolution problem = DemoDataBuilder.builder().setMinDemand(1).setMaxDemand(2).setVehicleCapacity(77).setCustomerCount(77).setVehicleCount(7).setDepotCount(1).setSouthWestCorner(new Location(0L, 51.44, -0.16)).setNorthEastCorner(new Location(0L, 51.56, -0.01)).build();
        problem.setScore(HardSoftLongScore.ZERO);
        return problem;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Location> getLocationList() {
        return this.locationList;
    }

    public void setLocationList(List<Location> locationList) {
        this.locationList = locationList;
    }

    public List<Depot> getDepotList() {
        return this.depotList;
    }

    public void setDepotList(List<Depot> depotList) {
        this.depotList = depotList;
    }

    public List<Vehicle> getVehicleList() {
        return this.vehicleList;
    }

    public void setVehicleList(List<Vehicle> vehicleList) {
        this.vehicleList = vehicleList;
    }

    public List<Customer> getCustomerList() {
        return this.customerList;
    }

    public void setCustomerList(List<Customer> customerList) {
        this.customerList = customerList;
    }

    public HardSoftLongScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftLongScore score) {
        this.score = score;
    }

    public List<Location> getBounds() {
        return Arrays.asList(this.southWestCorner, this.northEastCorner);
    }

    public long getDistanceMeters() {
        return this.score == null ? 0L : -this.score.getSoftScore();
    }

    public List $get$optaplanner$__field$__vehicleList() {
        return this.vehicleList;
    }

    public void $set$optaplanner$__field$__vehicleList(List list) {
        this.vehicleList = list;
    }

    public HardSoftLongScore $get$optaplanner$__field$__score() {
        return this.score;
    }

    public void $set$optaplanner$__field$__score(HardSoftLongScore hardSoftLongScore) {
        this.score = hardSoftLongScore;
    }

    public List $get$optaplanner$__field$__locationList() {
        return this.locationList;
    }

    public void $set$optaplanner$__field$__locationList(List list) {
        this.locationList = list;
    }

    public List $get$optaplanner$__field$__depotList() {
        return this.depotList;
    }

    public void $set$optaplanner$__field$__depotList(List list) {
        this.depotList = list;
    }

    public List $get$optaplanner$__field$__customerList() {
        return this.customerList;
    }

    public void $set$optaplanner$__field$__customerList(List list) {
        this.customerList = list;
    }

    public String $get$optaplanner$__field$__name() {
        return this.name;
    }

    public void $set$optaplanner$__field$__name(String string) {
        this.name = string;
    }

    public Location $get$optaplanner$__field$__southWestCorner() {
        return this.southWestCorner;
    }

    public void $set$optaplanner$__field$__southWestCorner(Location location) {
        this.southWestCorner = location;
    }

    public Location $get$optaplanner$__field$__northEastCorner() {
        return this.northEastCorner;
    }

    public void $set$optaplanner$__field$__northEastCorner(Location location) {
        this.northEastCorner = location;
    }
}

