/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractInserter;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.AbstractUpdater;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.common.AbstractConstraintStream;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class NodeBuildHelper<Score_ extends Score<Score_>> {
    private final Set<? extends ConstraintStream> activeStreamSet;
    private final Map<Constraint, Score_> constraintWeightMap;
    private final AbstractScoreInliner<Score_> scoreInliner;
    private final Map<ConstraintStream, Consumer<? extends Tuple>> insertMap;
    private final Map<ConstraintStream, Consumer<? extends Tuple>> updateMap;
    private final Map<ConstraintStream, Consumer<? extends Tuple>> retractMap;
    private final Map<ConstraintStream, Integer> storeIndexMap;
    private List<AbstractNode> reversedNodeList;

    public NodeBuildHelper(Set<? extends ConstraintStream> activeStreamSet, Map<Constraint, Score_> constraintWeightMap, AbstractScoreInliner<Score_> scoreInliner) {
        this.activeStreamSet = activeStreamSet;
        this.constraintWeightMap = constraintWeightMap;
        this.scoreInliner = scoreInliner;
        int activeStreamSetSize = activeStreamSet.size();
        int consumerMapSize = Math.max(16, activeStreamSetSize);
        this.insertMap = new HashMap<ConstraintStream, Consumer<? extends Tuple>>(consumerMapSize);
        this.updateMap = new HashMap<ConstraintStream, Consumer<? extends Tuple>>(consumerMapSize);
        this.retractMap = new HashMap<ConstraintStream, Consumer<? extends Tuple>>(consumerMapSize);
        this.storeIndexMap = new HashMap<ConstraintStream, Integer>(Math.max(16, activeStreamSetSize / 2));
        this.reversedNodeList = new ArrayList<AbstractNode>(activeStreamSetSize);
    }

    public boolean isStreamActive(ConstraintStream stream) {
        return this.activeStreamSet.contains(stream);
    }

    public AbstractScoreInliner<Score_> getScoreInliner() {
        return this.scoreInliner;
    }

    public Score_ getConstraintWeight(Constraint constraint) {
        return (Score_)((Score)this.constraintWeightMap.get(constraint));
    }

    public void addNode(AbstractNode node) {
        this.reversedNodeList.add(node);
    }

    public <Tuple_ extends Tuple> void putInsertUpdateRetract(ConstraintStream stream, Consumer<Tuple_> insert, Consumer<Tuple_> update, Consumer<Tuple_> retract) {
        this.insertMap.put(stream, insert);
        this.updateMap.put(stream, update);
        this.retractMap.put(stream, retract);
    }

    public <Tuple_ extends Tuple> void putInsertUpdateRetract(ConstraintStream stream, List<? extends AbstractConstraintStream> childStreamList, Function<Consumer<Tuple_>, AbstractInserter<Tuple_>> inserterConstructor, BiFunction<Consumer<Tuple_>, Consumer<Tuple_>, AbstractUpdater<Tuple_>> updaterConstructor) {
        Consumer<Tuple_> insert = this.getAggregatedInsert(childStreamList);
        Consumer<Tuple_> update = this.getAggregatedUpdate(childStreamList);
        Consumer<Tuple_> retract = this.getAggregatedRetract(childStreamList);
        this.putInsertUpdateRetract(stream, inserterConstructor.apply(insert), updaterConstructor.apply(update, retract), retract);
    }

    public <Tuple_ extends Tuple> Consumer<Tuple_> getAggregatedInsert(List<? extends ConstraintStream> streamList) {
        return this.getAggregatedConsumer(streamList, this.insertMap);
    }

    public <Tuple_ extends Tuple> Consumer<Tuple_> getAggregatedUpdate(List<? extends ConstraintStream> streamList) {
        return this.getAggregatedConsumer(streamList, this.updateMap);
    }

    public <Tuple_ extends Tuple> Consumer<Tuple_> getAggregatedRetract(List<? extends ConstraintStream> streamList) {
        return this.getAggregatedConsumer(streamList, this.retractMap);
    }

    private <Tuple_ extends Tuple> Consumer<Tuple_> getAggregatedConsumer(List<? extends ConstraintStream> streamList, Map<ConstraintStream, Consumer<? extends Tuple>> consumerMap) {
        Consumer[] consumers = (Consumer[])streamList.stream().filter(this::isStreamActive).map(s -> NodeBuildHelper.getConsumer(s, consumerMap)).toArray(Consumer[]::new);
        switch (consumers.length) {
            case 0: {
                throw new IllegalStateException("Impossible state: None of the streamList (" + streamList + ") are active.");
            }
            case 1: {
                return consumers[0];
            }
        }
        return new AggregatedConsumer(consumers);
    }

    private static <Tuple_ extends Tuple> Consumer<Tuple_> getConsumer(ConstraintStream stream, Map<ConstraintStream, Consumer<? extends Tuple>> consumerMap) {
        Consumer<? extends Tuple> consumer = consumerMap.get(stream);
        if (consumer == null) {
            throw new IllegalStateException("Impossible state: the stream (" + stream + ") hasn't built a node yet.");
        }
        return consumer;
    }

    public int reserveTupleStoreIndex(ConstraintStream tupleSourceStream) {
        return this.storeIndexMap.compute(tupleSourceStream, (k, index) -> {
            if (index == null) {
                return 0;
            }
            if (index < 0) {
                throw new IllegalStateException("Impossible state: the tupleSourceStream (" + k + ") is reserving a store after it has been extracted.");
            }
            return index + 1;
        });
    }

    public int extractTupleStoreSize(ConstraintStream tupleSourceStream) {
        Integer lastIndex = this.storeIndexMap.put(tupleSourceStream, Integer.MIN_VALUE);
        return lastIndex == null ? 0 : lastIndex + 1;
    }

    public List<AbstractNode> destroyAndGetNodeList() {
        List<AbstractNode> nodeList = this.reversedNodeList;
        Collections.reverse(nodeList);
        this.reversedNodeList = null;
        return nodeList;
    }

    private static final class AggregatedConsumer<Tuple_ extends Tuple>
    implements Consumer<Tuple_> {
        private final Consumer<Tuple_>[] consumers;

        public AggregatedConsumer(Consumer<Tuple_>[] consumers) {
            this.consumers = consumers;
        }

        @Override
        public void accept(Tuple_ tuple) {
            for (Consumer<Tuple_> consumer : this.consumers) {
                consumer.accept(tuple);
            }
        }
    }
}

