/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;

public abstract class UpcomingSelectionListIterator<S>
extends UpcomingSelectionIterator<S>
implements ListIterator<S> {
    private int nextListIteratorIndex = 0;
    protected S previousSelection;
    protected boolean previousCreated = false;
    protected boolean hasPreviousSelection = false;

    protected S noPreviousSelection() {
        this.hasPreviousSelection = false;
        return null;
    }

    @Override
    protected abstract S createUpcomingSelection();

    protected abstract S createPreviousSelection();

    @Override
    public boolean hasPrevious() {
        if (!this.previousCreated) {
            this.previousSelection = this.createPreviousSelection();
            this.previousCreated = true;
        }
        return this.hasPreviousSelection;
    }

    @Override
    public S next() {
        Object next = super.next();
        ++this.nextListIteratorIndex;
        this.hasPreviousSelection = true;
        return next;
    }

    @Override
    public S previous() {
        if (!this.hasPreviousSelection) {
            throw new NoSuchElementException();
        }
        if (!this.previousCreated) {
            this.previousSelection = this.createPreviousSelection();
        }
        this.previousCreated = false;
        --this.nextListIteratorIndex;
        this.hasUpcomingSelection = true;
        return this.previousSelection;
    }

    @Override
    public int nextIndex() {
        return this.nextListIteratorIndex;
    }

    @Override
    public int previousIndex() {
        return this.nextListIteratorIndex - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The optional operation remove() is not supported.");
    }

    @Override
    public void set(S o) {
        throw new UnsupportedOperationException("The optional operation set(...) is not supported.");
    }

    @Override
    public void add(S o) {
        throw new UnsupportedOperationException("The optional operation add(...) is not supported.");
    }
}

