/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.util.List;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractCompositeTermination;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;

public class OrCompositeTermination<Solution_>
extends AbstractCompositeTermination<Solution_> {
    public OrCompositeTermination(List<Termination<Solution_>> terminationList) {
        super(terminationList);
    }

    public OrCompositeTermination(Termination<Solution_> ... terminations) {
        super(terminations);
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        for (Termination termination : this.terminationList) {
            if (!termination.isSolverTerminated(solverScope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        for (Termination termination : this.terminationList) {
            if (!termination.isPhaseTerminated(phaseScope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        double timeGradient = 0.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculateSolverTimeGradient(solverScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.max(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        double timeGradient = 0.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculatePhaseTimeGradient(phaseScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.max(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public OrCompositeTermination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new OrCompositeTermination<Solution_>(this.createChildThreadTerminationList(solverScope, childThreadType));
    }

    public String toString() {
        return "Or(" + this.terminationList + ")";
    }
}

