/*
 * Decompiled with CFR 0.152.
 */
package org.acme.callcenter.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import org.acme.callcenter.domain.Agent;
import org.acme.callcenter.domain.Call;
import org.acme.callcenter.domain.CallCenter;
import org.acme.callcenter.domain.Skill;

@ApplicationScoped
public class DataGenerator {
    private static final AtomicLong NEXT_ID = new AtomicLong(0L);
    private final Random RANDOM = new Random(37L);
    private static final Agent[] AGENTS = new Agent[]{new Agent(DataGenerator.nextId(), "Ann", DataGenerator.buildSkillSet(Skill.ENGLISH, Skill.LIFE_INSURANCE, Skill.PROPERTY_INSURANCE)), new Agent(DataGenerator.nextId(), "Beth", DataGenerator.buildSkillSet(Skill.ENGLISH, Skill.SPANISH, Skill.CAR_INSURANCE)), new Agent(DataGenerator.nextId(), "Carl", DataGenerator.buildSkillSet(Skill.ENGLISH, Skill.PROPERTY_INSURANCE)), new Agent(DataGenerator.nextId(), "Dennis", DataGenerator.buildSkillSet(Skill.SPANISH, Skill.LIFE_INSURANCE)), new Agent(DataGenerator.nextId(), "Elsa", DataGenerator.buildSkillSet(Skill.SPANISH, Skill.CAR_INSURANCE, Skill.PROPERTY_INSURANCE)), new Agent(DataGenerator.nextId(), "Francis", DataGenerator.buildSkillSet(Skill.SPANISH, Skill.PROPERTY_INSURANCE)), new Agent(DataGenerator.nextId(), "Gus", DataGenerator.buildSkillSet(Skill.GERMAN, Skill.ENGLISH, Skill.LIFE_INSURANCE)), new Agent(DataGenerator.nextId(), "Hugo", DataGenerator.buildSkillSet(Skill.GERMAN, Skill.CAR_INSURANCE, Skill.PROPERTY_INSURANCE))};
    private static final Skill[] LANGUAGE_SKILLS = new Skill[]{Skill.ENGLISH, Skill.SPANISH, Skill.GERMAN};
    private static final Skill[] PRODUCT_SKILLS = new Skill[]{Skill.CAR_INSURANCE, Skill.LIFE_INSURANCE, Skill.PROPERTY_INSURANCE};

    private static Set<Skill> buildSkillSet(Skill ... skills) {
        return EnumSet.copyOf(Arrays.asList(skills));
    }

    public CallCenter generateCallCenter() {
        return new CallCenter(EnumSet.allOf(Skill.class), Arrays.asList(AGENTS), new ArrayList<Call>());
    }

    public Call generateCall(int durationSeconds) {
        return new Call(DataGenerator.nextId(), this.generatePhoneNumber(), DataGenerator.buildSkillSet(this.pickRandomLanguageSkill(), this.pickRandomProductSkill()), durationSeconds);
    }

    private synchronized Skill pickRandomProductSkill() {
        return PRODUCT_SKILLS[this.RANDOM.nextInt(PRODUCT_SKILLS.length)];
    }

    private synchronized Skill pickRandomLanguageSkill() {
        return LANGUAGE_SKILLS[this.RANDOM.nextInt(PRODUCT_SKILLS.length)];
    }

    private synchronized String generatePhoneNumber() {
        int firstGroup = this.RANDOM.nextInt(1000);
        int secondGroup = this.RANDOM.nextInt(1000);
        int thirdGroup = this.RANDOM.nextInt(10000);
        return firstGroup + "-" + secondGroup + "-" + thirdGroup;
    }

    private static long nextId() {
        return NEXT_ID.getAndIncrement();
    }
}

