/*
 * Decompiled with CFR 0.152.
 */
package org.acme.callcenter.rest;

import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.acme.callcenter.data.DataGenerator;
import org.acme.callcenter.domain.CallCenter;
import org.acme.callcenter.service.SimulationService;
import org.acme.callcenter.service.SolverService;

@Path(value="/call-center")
public class CallCenterResource {
    private AtomicReference<CallCenter> bestSolution = new AtomicReference();
    private AtomicReference<Throwable> solvingError = new AtomicReference();
    @Inject
    SolverService solverService;
    @Inject
    SimulationService simulationService;

    @Inject
    CallCenterResource(DataGenerator dataGenerator) {
        this.bestSolution.set(dataGenerator.generateCallCenter());
    }

    @GET
    @Produces(value={"application/json"})
    public CallCenter get() {
        if (this.solvingError.get() != null) {
            throw new IllegalStateException("Exception occurred during solving.", this.solvingError.get());
        }
        CallCenter callCenter = this.bestSolution.get();
        callCenter.setSolving(this.solverService.isSolving());
        return callCenter;
    }

    @POST
    @Path(value="solve")
    public void solve() {
        this.solverService.startSolving(this.bestSolution.get(), bestSolutionChangedEvent -> {
            this.bestSolution.set((CallCenter)bestSolutionChangedEvent.getNewBestSolution());
            this.simulationService.onNewBestSolution((CallCenter)bestSolutionChangedEvent.getNewBestSolution());
        }, throwable -> this.solvingError.set((Throwable)throwable));
        this.simulationService.startSimulation();
    }

    @POST
    @Path(value="stop")
    public void stop() {
        this.solverService.stopSolving();
        this.simulationService.stopSimulation();
    }
}

