/*
 * Decompiled with CFR 0.152.
 */
package org.acme.callcenter.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.acme.callcenter.domain.Agent;
import org.acme.callcenter.domain.Call;
import org.acme.callcenter.domain.CallCenter;
import org.acme.callcenter.solver.change.AddCallProblemChange;
import org.acme.callcenter.solver.change.PinCallProblemChange;
import org.acme.callcenter.solver.change.ProlongCallByMinuteProblemChange;
import org.acme.callcenter.solver.change.RemoveCallProblemChange;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;

@ApplicationScoped
public class SolverService {
    private final ManagedExecutor managedExecutor;
    private final Solver<CallCenter> solver;
    private AtomicBoolean solving = new AtomicBoolean(false);
    private CompletableFuture<?> completableSolverFuture;
    private final BlockingQueue<ProblemChange<CallCenter>> waitingProblemChanges = new LinkedBlockingQueue<ProblemChange<CallCenter>>();

    @Inject
    public SolverService(SolverFactory<CallCenter> solverFactory, @Default ManagedExecutor executorService) {
        this.solver = solverFactory.buildSolver();
        this.managedExecutor = executorService;
    }

    private void pinCallAssignedToAgents(List<Call> calls) {
        calls.stream().filter(call -> !call.isPinned() && call.getPreviousCallOrAgent() != null && call.getPreviousCallOrAgent() instanceof Agent).map(PinCallProblemChange::new).forEach(arg_0 -> this.solver.addProblemChange(arg_0));
    }

    public void startSolving(CallCenter inputProblem, Consumer<BestSolutionChangedEvent<CallCenter>> bestSolutionChangedEventConsumer, Consumer<Throwable> errorHandler) {
        this.solving.set(true);
        this.completableSolverFuture = this.managedExecutor.runAsync(() -> {
            this.solver.addEventListener(event -> {
                if (event.isEveryProblemChangeProcessed() && event.getNewBestScore().isSolutionInitialized()) {
                    this.pinCallAssignedToAgents(((CallCenter)event.getNewBestSolution()).getCalls());
                    bestSolutionChangedEventConsumer.accept(event);
                }
            });
            try {
                this.solver.solve((Object)inputProblem);
            }
            catch (Throwable throwable) {
                errorHandler.accept(throwable);
            }
            this.solver.addProblemChanges(new ArrayList<ProblemChange<CallCenter>>(this.waitingProblemChanges));
        });
    }

    public void stopSolving() {
        this.solving.set(false);
        if (this.completableSolverFuture != null) {
            this.solver.terminateEarly();
            try {
                this.completableSolverFuture.get();
                this.completableSolverFuture = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to stop solver.", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failed to stop solver.", e.getCause());
            }
        }
    }

    public boolean isSolving() {
        return this.solving.get();
    }

    public void addCall(Call call) {
        this.registerProblemChange(new AddCallProblemChange(call));
    }

    public void removeCall(long callId) {
        this.registerProblemChange(new RemoveCallProblemChange(callId));
    }

    public void prolongCall(long callId) {
        this.registerProblemChange(new ProlongCallByMinuteProblemChange(callId));
    }

    private void registerProblemChange(ProblemChange<CallCenter> problemChange) {
        if (this.isSolving()) {
            this.assertSolverIsAlive();
            this.solver.addProblemChange(problemChange);
        } else {
            this.waitingProblemChanges.add(problemChange);
        }
    }

    private void assertSolverIsAlive() {
        if (this.completableSolverFuture == null) {
            throw new IllegalStateException("Solver has not been started yet.");
        }
        if (this.completableSolverFuture.isDone()) {
            try {
                this.completableSolverFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Solver thread was interrupted.", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Solver thread has died.", e.getCause());
            }
            throw new IllegalStateException("Solver has finished solving even though it operates in daemon mode.");
        }
    }
}

