/*
 * Decompiled with CFR 0.152.
 */
package org.acme.callcenter.solver;

import org.acme.callcenter.domain.Call;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;

public class CallCenterConstraintsProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.noRequiredSkillMissing(constraintFactory), this.minimizeWaitingTime(constraintFactory)};
    }

    Constraint noRequiredSkillMissing(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Call.class).filter(call -> call.getMissingSkillCount() > 0).penalize("No required skills are missing", (Score)HardSoftScore.ONE_HARD, call -> call.getMissingSkillCount());
    }

    Constraint minimizeWaitingTime(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Call.class).filter(call -> call.getNextCall() == null).penalize("Minimize waiting time", (Score)HardSoftScore.ONE_SOFT, call -> Math.toIntExact(call.getEstimatedWaiting().getSeconds() * call.getEstimatedWaiting().getSeconds()));
    }
}

