/*
 * Decompiled with CFR 0.152.
 */
package org.acme.callcenter.solver;

import java.time.Duration;
import org.acme.callcenter.domain.Call;
import org.acme.callcenter.domain.CallCenter;
import org.acme.callcenter.domain.PreviousCallOrAgent;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;

public class ResponseTimeUpdatingVariableListener
implements VariableListener<CallCenter, Call> {
    public void beforeEntityAdded(ScoreDirector<CallCenter> scoreDirector, Call call) {
    }

    public void afterEntityAdded(ScoreDirector<CallCenter> scoreDirector, Call call) {
        this.updateResponseTime(scoreDirector, call);
    }

    public void beforeVariableChanged(ScoreDirector<CallCenter> scoreDirector, Call call) {
    }

    public void afterVariableChanged(ScoreDirector<CallCenter> scoreDirector, Call call) {
        this.updateResponseTime(scoreDirector, call);
    }

    public void beforeEntityRemoved(ScoreDirector<CallCenter> scoreDirector, Call call) {
    }

    public void afterEntityRemoved(ScoreDirector<CallCenter> scoreDirector, Call call) {
    }

    protected void updateResponseTime(ScoreDirector<CallCenter> scoreDirector, Call call) {
        Call shadowCall;
        PreviousCallOrAgent previous = call.getPreviousCallOrAgent();
        Duration previousDurationTillPickUp = previous == null ? null : previous.getDurationTillPickUp();
        Duration estimatedWaiting = this.calculateWaitingTimeEstimate(shadowCall, previousDurationTillPickUp);
        for (shadowCall = call; shadowCall != null; shadowCall = shadowCall.getNextCall()) {
            scoreDirector.beforeVariableChanged((Object)shadowCall, "estimatedWaiting");
            shadowCall.setEstimatedWaiting(estimatedWaiting);
            scoreDirector.afterVariableChanged((Object)shadowCall, "estimatedWaiting");
            previousDurationTillPickUp = shadowCall.getDurationTillPickUp();
            estimatedWaiting = this.calculateWaitingTimeEstimate(shadowCall, previousDurationTillPickUp);
        }
    }

    private Duration calculateWaitingTimeEstimate(Call call, Duration previousEndTime) {
        if (call == null || previousEndTime == null) {
            return null;
        }
        return previousEndTime;
    }
}

