/*
 * Decompiled with CFR 0.152.
 */
package org.acme.callcenter.solver.change;

import java.util.Optional;
import org.acme.callcenter.domain.Call;
import org.acme.callcenter.domain.CallCenter;
import org.acme.callcenter.domain.PreviousCallOrAgent;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;

public class RemoveCallProblemChange
implements ProblemChange<CallCenter> {
    private final long callId;

    public RemoveCallProblemChange(long callId) {
        this.callId = callId;
    }

    public void doChange(CallCenter workingCallCenter, ProblemChangeDirector problemChangeDirector) {
        Call call = new Call(this.callId, null);
        Optional workingCallOptional = problemChangeDirector.lookUpWorkingObject((Object)call);
        workingCallOptional.ifPresent(workingCall -> this.removeCall((Call)workingCall, workingCallCenter, problemChangeDirector));
    }

    private void removeCall(Call call, CallCenter workingCallCenter, ProblemChangeDirector problemChangeDirector) {
        PreviousCallOrAgent previousCallOrAgent = call.getPreviousCallOrAgent();
        Call nextCall = call.getNextCall();
        if (nextCall != null) {
            problemChangeDirector.changeVariable((Object)nextCall, "previousCallOrAgent", workingNextCall -> workingNextCall.setPreviousCallOrAgent(previousCallOrAgent));
        }
        problemChangeDirector.removeEntity((Object)call, workingCallCenter.getCalls()::remove);
    }
}

