/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.mimic;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.AbstractEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.EntityMimicRecorder;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public class MimicReplayingEntitySelector<Solution_>
extends AbstractEntitySelector<Solution_> {
    protected final EntityMimicRecorder<Solution_> entityMimicRecorder;
    protected boolean hasRecordingCreated;
    protected boolean hasRecording;
    protected boolean recordingCreated;
    protected Object recording;
    protected boolean recordingAlreadyReturned;

    public MimicReplayingEntitySelector(EntityMimicRecorder<Solution_> entityMimicRecorder) {
        this.entityMimicRecorder = entityMimicRecorder;
        entityMimicRecorder.addMimicReplayingEntitySelector(this);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.hasRecordingCreated = false;
        this.recordingCreated = false;
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.hasRecordingCreated = false;
        this.hasRecording = false;
        this.recordingCreated = false;
        this.recording = null;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.entityMimicRecorder.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.entityMimicRecorder.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.entityMimicRecorder.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.entityMimicRecorder.getSize();
    }

    @Override
    public Iterator<Object> iterator() {
        return new ReplayingEntityIterator();
    }

    public void recordedHasNext(boolean hasNext) {
        this.hasRecordingCreated = true;
        this.hasRecording = hasNext;
        this.recordingCreated = false;
        this.recording = null;
        this.recordingAlreadyReturned = false;
    }

    public void recordedNext(Object next) {
        this.hasRecordingCreated = true;
        this.hasRecording = true;
        this.recordingCreated = true;
        this.recording = next;
        this.recordingAlreadyReturned = false;
    }

    @Override
    public Iterator<Object> endingIterator() {
        return this.entityMimicRecorder.endingIterator();
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Replaying(" + this.entityMimicRecorder + ")";
    }

    private class ReplayingEntityIterator
    extends SelectionIterator<Object> {
        private ReplayingEntityIterator() {
            MimicReplayingEntitySelector.this.recordingAlreadyReturned = false;
        }

        @Override
        public boolean hasNext() {
            if (!MimicReplayingEntitySelector.this.hasRecordingCreated) {
                throw new IllegalStateException("Replay must occur after record. The recordingEntitySelector (" + MimicReplayingEntitySelector.this.entityMimicRecorder + ")'s hasNext() has not been called yet. ");
            }
            return MimicReplayingEntitySelector.this.hasRecording && !MimicReplayingEntitySelector.this.recordingAlreadyReturned;
        }

        @Override
        public Object next() {
            if (!MimicReplayingEntitySelector.this.recordingCreated) {
                throw new IllegalStateException("Replay must occur after record. The recordingEntitySelector (" + MimicReplayingEntitySelector.this.entityMimicRecorder + ")'s next() has not been called yet. ");
            }
            if (MimicReplayingEntitySelector.this.recordingAlreadyReturned) {
                throw new NoSuchElementException("The recordingAlreadyReturned (" + MimicReplayingEntitySelector.this.recordingAlreadyReturned + ") is impossible. Check if hasNext() returns true before this call.");
            }
            MimicReplayingEntitySelector.this.recordingAlreadyReturned = true;
            return MimicReplayingEntitySelector.this.recording;
        }

        public String toString() {
            if (MimicReplayingEntitySelector.this.hasRecordingCreated && !MimicReplayingEntitySelector.this.hasRecording) {
                return "No next replay";
            }
            return "Next replay (" + (MimicReplayingEntitySelector.this.recordingCreated ? MimicReplayingEntitySelector.this.recording : "?") + ")";
        }
    }
}

