/*
 * Decompiled with CFR 0.152.
 */
package org.acme.employeescheduling.rest;

import io.quarkus.panache.common.Sort;
import java.time.LocalDate;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.acme.employeescheduling.bootstrap.DemoDataGenerator;
import org.acme.employeescheduling.domain.EmployeeSchedule;
import org.acme.employeescheduling.domain.ScheduleState;
import org.acme.employeescheduling.domain.Shift;
import org.acme.employeescheduling.persistence.AvailabilityRepository;
import org.acme.employeescheduling.persistence.EmployeeRepository;
import org.acme.employeescheduling.persistence.ScheduleStateRepository;
import org.acme.employeescheduling.persistence.ShiftRepository;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;

@Path(value="/schedule")
public class EmployeeScheduleResource {
    public static final Long SINGLETON_SCHEDULE_ID = 1L;
    @Inject
    AvailabilityRepository availabilityRepository;
    @Inject
    EmployeeRepository employeeRepository;
    @Inject
    ShiftRepository shiftRepository;
    @Inject
    ScheduleStateRepository scheduleStateRepository;
    @Inject
    DemoDataGenerator dataGenerator;
    @Inject
    SolverManager<EmployeeSchedule, Long> solverManager;
    @Inject
    ScoreManager<EmployeeSchedule, HardSoftScore> scoreManager;

    @GET
    public EmployeeSchedule getSchedule() {
        SolverStatus solverStatus = this.getSolverStatus();
        EmployeeSchedule solution = this.findById(SINGLETON_SCHEDULE_ID);
        this.scoreManager.updateScore((Object)solution);
        solution.setSolverStatus(solverStatus);
        return solution;
    }

    public SolverStatus getSolverStatus() {
        return this.solverManager.getSolverStatus((Object)SINGLETON_SCHEDULE_ID);
    }

    @POST
    @Path(value="solve")
    public void solve() {
        this.solverManager.solveAndListen((Object)SINGLETON_SCHEDULE_ID, this::findById, this::save);
    }

    @POST
    @Transactional
    @Path(value="publish")
    public void publish() {
        if (!this.getSolverStatus().equals((Object)SolverStatus.NOT_SOLVING)) {
            throw new IllegalStateException("Cannot publish a schedule while solving is in progress.");
        }
        ScheduleState scheduleState = (ScheduleState)this.scheduleStateRepository.findById(SINGLETON_SCHEDULE_ID);
        LocalDate newHistoricDate = scheduleState.getFirstDraftDate();
        LocalDate newDraftDate = scheduleState.getFirstDraftDate().plusDays(scheduleState.getPublishLength().intValue());
        scheduleState.setLastHistoricDate(newHistoricDate);
        scheduleState.setFirstDraftDate(newDraftDate);
        this.dataGenerator.generateDraftShifts(scheduleState);
    }

    @POST
    @Path(value="stopSolving")
    public void stopSolving() {
        this.solverManager.terminateEarly((Object)SINGLETON_SCHEDULE_ID);
    }

    @Transactional
    protected EmployeeSchedule findById(Long id) {
        if (!SINGLETON_SCHEDULE_ID.equals(id)) {
            throw new IllegalStateException("There is no schedule with id (" + id + ").");
        }
        return new EmployeeSchedule((ScheduleState)this.scheduleStateRepository.findById(SINGLETON_SCHEDULE_ID), this.availabilityRepository.listAll(Sort.by((String)"date").and("id")), this.employeeRepository.listAll(Sort.by((String)"name")), this.shiftRepository.listAll(Sort.by((String)"location").and("start").and("id")));
    }

    @Transactional
    protected void save(EmployeeSchedule schedule) {
        for (Shift shift : schedule.getShiftList()) {
            Shift attachedShift = (Shift)this.shiftRepository.findById(shift.getId());
            attachedShift.setEmployee(shift.getEmployee());
        }
    }
}

