/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirector;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.test.api.score.stream.SingleConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultSingleConstraintAssertion;

public final class DefaultSingleConstraintVerification<Solution_, Score_ extends Score<Score_>>
implements SingleConstraintVerification<Solution_> {
    private final ConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;

    protected DefaultSingleConstraintVerification(ConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
    }

    private void assertDistinctPlanningIds(SolutionDescriptor<Solution_> solutionDescriptor, Object ... facts) {
        if (facts.length < 2) {
            return;
        }
        Map entitiesByClassMap = Arrays.stream(facts).filter(fact -> solutionDescriptor.hasEntityDescriptor(fact.getClass())).collect(Collectors.groupingBy(fact -> {
            EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptor(fact.getClass());
            return entityDescriptor.getEntityClass();
        }, ConcurrentHashMap::new, Collectors.toList()));
        entitiesByClassMap.forEach((clz, clzFacts) -> {
            MemberAccessor planningIdAccessor = ConfigUtils.findPlanningIdMemberAccessor((Class)clz, (DomainAccessType)solutionDescriptor.getDomainAccessType());
            if (planningIdAccessor == null) {
                return;
            }
            Map<Optional, List<Object>> entitiesWithSameIdMap = clzFacts.stream().collect(Collectors.groupingBy(fact -> {
                Long planningId = (Long)planningIdAccessor.executeGetter(fact);
                return Optional.ofNullable(planningId);
            }));
            Optional<Map.Entry> firstDuplicateIdEntry = entitiesWithSameIdMap.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).findFirst();
            firstDuplicateIdEntry.ifPresent(entry -> {
                String value = ((Optional)entry.getKey()).map(id -> Long.toString(id)).orElse("null");
                throw new IllegalStateException("Multiple instances of " + PlanningEntity.class.getSimpleName() + "-annotated class (" + clz.getCanonicalName() + ") share the same " + PlanningId.class.getSimpleName() + " value (" + value + ").\nThe instances are (" + entry.getValue() + ").\nMake sure that IDs of entities passed into the given(...) method are unique.");
            });
        });
    }

    @Override
    public final DefaultSingleConstraintAssertion<Solution_, Score_> given(Object ... facts) {
        this.assertDistinctPlanningIds(this.scoreDirectorFactory.getSolutionDescriptor(), facts);
        try (ConstraintSession constraintSession = this.scoreDirectorFactory.newConstraintStreamingSession(true, null);){
            Arrays.stream(facts).forEach(arg_0 -> ((ConstraintSession)constraintSession).insert(arg_0));
            DefaultSingleConstraintAssertion<Solution_, Score> defaultSingleConstraintAssertion = new DefaultSingleConstraintAssertion<Solution_, Score>(this.scoreDirectorFactory, constraintSession.calculateScore(0), constraintSession.getConstraintMatchTotalMap(), constraintSession.getIndictmentMap());
            return defaultSingleConstraintAssertion;
        }
    }

    @Override
    public final DefaultSingleConstraintAssertion<Solution_, Score_> givenSolution(Solution_ solution) {
        try (ConstraintStreamScoreDirector scoreDirector = this.scoreDirectorFactory.buildScoreDirector(true, true);){
            scoreDirector.setWorkingSolution(Objects.requireNonNull(solution));
            DefaultSingleConstraintAssertion<Solution_, Score> defaultSingleConstraintAssertion = new DefaultSingleConstraintAssertion<Solution_, Score>(this.scoreDirectorFactory, scoreDirector.calculateScore(), scoreDirector.getConstraintMatchTotalMap(), scoreDirector.getIndictmentMap());
            return defaultSingleConstraintAssertion;
        }
    }
}

