/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.builder.impl.KogitoKieModuleMarshaller;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.util.StringUtils;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;

public class KogitoKieModuleModelImpl
implements KieModuleModel {
    public static final String KMODULE_FILE_NAME = "kmodule.xml";
    public static final String KMODULE_JAR_PATH = "META-INF/kmodule.xml";
    public static final String KMODULE_INFO_JAR_PATH = "META-INF/kmodule.info";
    public static final String KMODULE_SRC_PATH = "src/main/resources/META-INF/kmodule.xml";
    public static final String KMODULE_SPRING_JAR_PATH = "META-INF/kmodule-spring.xml";
    private Map<String, String> confProps = new HashMap<String, String>();
    private Map<String, KieBaseModel> kBases = new HashMap<String, KieBaseModel>();
    private static final String KMODULE_XSD = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\"";

    public KieModuleModel setConfigurationProperty(String key, String value) {
        this.confProps.put(key, value);
        return this;
    }

    public String getConfigurationProperty(String key) {
        return this.confProps.get(key);
    }

    public Map<String, String> getConfigurationProperties() {
        return this.confProps;
    }

    public KieBaseModel newKieBaseModel() {
        return this.newKieBaseModel(StringUtils.uuid());
    }

    public KieBaseModel newKieBaseModel(String name) {
        KieBaseModelImpl kbase = new KieBaseModelImpl((KieModuleModel)this, name);
        HashMap<String, KieBaseModel> newMap = new HashMap<String, KieBaseModel>();
        newMap.putAll(this.kBases);
        newMap.put(kbase.getName(), (KieBaseModel)kbase);
        this.setKBases(newMap);
        return kbase;
    }

    public void removeKieBaseModel(String qName) {
        HashMap<String, KieBaseModel> newMap = new HashMap<String, KieBaseModel>();
        newMap.putAll(this.kBases);
        newMap.remove(qName);
        this.setKBases(newMap);
    }

    public void moveKBase(String oldQName, String newQName) {
        HashMap<String, KieBaseModel> newMap = new HashMap<String, KieBaseModel>();
        newMap.putAll(this.kBases);
        KieBaseModel kieBaseModel = (KieBaseModel)newMap.remove(oldQName);
        newMap.put(newQName, kieBaseModel);
        this.setKBases(newMap);
    }

    public Map<String, KieBaseModel> getKieBaseModels() {
        return Collections.unmodifiableMap(this.kBases);
    }

    public Map<String, KieBaseModel> getRawKieBaseModels() {
        return this.kBases;
    }

    private void setKBases(Map<String, KieBaseModel> kBases) {
        this.kBases = kBases;
    }

    void changeKBaseName(KieBaseModel kieBase, String oldName, String newName) {
        this.kBases.remove(oldName);
        this.kBases.put(newName, kieBase);
    }

    Map<String, String> getConfProps() {
        return this.confProps;
    }

    void setConfProps(Map<String, String> confProps) {
        this.confProps = confProps;
    }

    public String toString() {
        return "KieModuleModel [kbases=" + this.kBases + "]";
    }

    public String toXML() {
        String xml = KogitoKieModuleMarshaller.MARSHALLER.toXML(this);
        return KMODULE_XSD + xml.substring("<kmodule".length());
    }

    public static KieModuleModel fromXML(InputStream kModuleStream) {
        return KogitoKieModuleMarshaller.MARSHALLER.fromXML(kModuleStream);
    }

    public static KieModuleModel fromXML(File kModuleFile) {
        return KogitoKieModuleMarshaller.MARSHALLER.fromXML(kModuleFile);
    }

    public static KieModuleModel fromXML(URL kModuleUrl) {
        return KogitoKieModuleMarshaller.MARSHALLER.fromXML(kModuleUrl);
    }

    public static KieModuleModel fromXML(String kModuleString) {
        return KogitoKieModuleMarshaller.MARSHALLER.fromXML(kModuleString);
    }
}

