/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.impl.score.inliner.BigDecimalWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.IntWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.LongWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraint;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetScoringBiNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniConstraintStream;

public final class BavetScoringBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B> {
    private final BavetAbstractBiConstraintStream<Solution_, A, B> parent;
    private final BavetConstraint<Solution_> constraint;
    private final boolean noMatchWeigher;
    private final ToIntBiFunction<A, B> intMatchWeigher;
    private final ToLongBiFunction<A, B> longMatchWeigher;
    private final BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher;

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BavetConstraint<Solution_> constraint) {
        this(constraintFactory, parent, constraint, true, null, null, null);
    }

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BavetConstraint<Solution_> constraint, ToIntBiFunction<A, B> intMatchWeigher) {
        this(constraintFactory, parent, constraint, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BavetConstraint<Solution_> constraint, ToLongBiFunction<A, B> longMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BavetConstraint<Solution_> constraint, BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BavetConstraint<Solution_> constraint, boolean noMatchWeigher, ToIntBiFunction<A, B> intMatchWeigher, ToLongBiFunction<A, B> longMatchWeigher, BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory);
        this.parent = parent;
        this.constraint = constraint;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public List<BavetFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return this.parent.getFromStreamList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BavetScoringBiNode<A, B> createNode(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractBiNode<A, B> parentNode) {
        TriFunction<Object, Object, Consumer, UndoScoreImpacter> scoreImpacter;
        ScoreInliner<Score<?>> scoreInliner = buildPolicy.getSession().getScoreInliner();
        WeightedScoreImpacter weightedScoreImpacter = scoreInliner.buildWeightedScoreImpacter(constraintWeight);
        if (weightedScoreImpacter instanceof IntWeightedScoreImpacter) {
            IntWeightedScoreImpacter intWeightedScoreImpacter = (IntWeightedScoreImpacter)weightedScoreImpacter;
            if (this.intMatchWeigher != null) {
                scoreImpacter = (a, b, matchScoreConsumer) -> {
                    int matchWeight = this.intMatchWeigher.applyAsInt(a, b);
                    this.constraint.assertCorrectImpact(matchWeight);
                    return intWeightedScoreImpacter.impactScore(matchWeight, (Consumer<Score<?>>)matchScoreConsumer);
                };
            } else {
                if (!this.noMatchWeigher) throw new IllegalStateException("The matchWeigher of " + BiConstraintStream.class.getSimpleName() + ".penalize(matchWeigher) of the constraint (" + this.constraint.getConstraintId() + ") must return an int.\nMaybe switch to penalize() or reward().");
                scoreImpacter = (a, b, matchScoreConsumer) -> intWeightedScoreImpacter.impactScore(1, (Consumer<Score<?>>)matchScoreConsumer);
            }
        } else if (weightedScoreImpacter instanceof LongWeightedScoreImpacter) {
            LongWeightedScoreImpacter longWeightedScoreImpacter = (LongWeightedScoreImpacter)weightedScoreImpacter;
            if (this.longMatchWeigher != null) {
                scoreImpacter = (a, b, matchScoreConsumer) -> {
                    long matchWeight = this.longMatchWeigher.applyAsLong(a, b);
                    this.constraint.assertCorrectImpact(matchWeight);
                    return longWeightedScoreImpacter.impactScore(matchWeight, (Consumer<Score<?>>)matchScoreConsumer);
                };
            } else {
                if (!this.noMatchWeigher) throw new IllegalStateException("The matchWeigher of " + BiConstraintStream.class.getSimpleName() + ".penalize(matchWeigher) of the constraint (" + this.constraint.getConstraintId() + ") must return a long.\nMaybe switch to penalizeLong() or rewardLong().");
                scoreImpacter = (a, b, matchScoreConsumer) -> longWeightedScoreImpacter.impactScore(1L, (Consumer<Score<?>>)matchScoreConsumer);
            }
        } else {
            if (!(weightedScoreImpacter instanceof BigDecimalWeightedScoreImpacter)) throw new IllegalStateException("Unsupported weightedScoreImpacter (" + weightedScoreImpacter + ").");
            BigDecimalWeightedScoreImpacter bigDecimalWeightedScoreImpacter = (BigDecimalWeightedScoreImpacter)weightedScoreImpacter;
            if (this.bigDecimalMatchWeigher != null) {
                scoreImpacter = (a, b, matchScoreConsumer) -> {
                    BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b);
                    this.constraint.assertCorrectImpact(matchWeight);
                    return bigDecimalWeightedScoreImpacter.impactScore(matchWeight, (Consumer<Score<?>>)matchScoreConsumer);
                };
            } else {
                if (!this.noMatchWeigher) throw new IllegalStateException("The matchWeigher of " + BiConstraintStream.class.getSimpleName() + ".penalize(matchWeigher) of the constraint (" + this.constraint.getConstraintId() + ") must return a " + BigDecimal.class.getSimpleName() + ".\nMaybe switch to penalizeBigDecimal() or rewardBigDecimal().");
                scoreImpacter = (a, b, matchScoreConsumer) -> bigDecimalWeightedScoreImpacter.impactScore(BigDecimal.ONE, (Consumer<Score<?>>)matchScoreConsumer);
            }
        }
        BavetScoringBiNode<Object, Object> bavetScoringBiNode = new BavetScoringBiNode<Object, Object>(buildPolicy.getSession(), buildPolicy.nextNodeIndex(), this.constraint.getConstraintPackage(), this.constraint.getConstraintName(), constraintWeight, scoreImpacter);
        buildPolicy.addScoringNode(bavetScoringBiNode);
        return bavetScoringBiNode;
    }

    @Override
    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractBiNode<A, B> node) {
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's an endpoint.");
        }
    }

    public String toString() {
        return "Scoring()";
    }
}

