/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.ArrayList;
import java.util.Objects;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;

abstract class AbstractLeftHandSide {
    protected final DroolsVariableFactory variableFactory;

    protected AbstractLeftHandSide(DroolsVariableFactory variableFactory) {
        this.variableFactory = Objects.requireNonNull(variableFactory);
    }

    protected static Index.ConstraintType getConstraintType(JoinerType type) {
        switch (type) {
            case EQUAL: {
                return Index.ConstraintType.EQUAL;
            }
            case LESS_THAN: {
                return Index.ConstraintType.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return Index.ConstraintType.LESS_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Index.ConstraintType.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return Index.ConstraintType.GREATER_OR_EQUAL;
            }
        }
        throw new IllegalStateException("Unsupported joiner type (" + (Object)((Object)type) + ").");
    }

    protected static ViewItem<?> joinViewItemsWithLogicalAnd(PatternVariable<?, ?, ?> ... patternVariables) {
        ArrayList viewItemList = new ArrayList();
        for (PatternVariable<?, ?, ?> patternVariable : patternVariables) {
            viewItemList.addAll(patternVariable.build());
        }
        int viewItemListSize = viewItemList.size();
        ViewItem firstPattern = (ViewItem)viewItemList.get(0);
        if (viewItemListSize == 1) {
            return firstPattern;
        }
        ViewItem[] remainingPatternArray = viewItemList.subList(1, viewItemListSize).toArray(new ViewItem[0]);
        return DSL.and((ViewItemBuilder)firstPattern, (ViewItemBuilder[])remainingPatternArray);
    }
}

