/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import org.drools.model.DSL;
import org.drools.model.Variable;
import org.drools.model.functions.Block6;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.ConsequenceBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.RuleBuilder;

final class QuadRuleContext<A, B, C, D>
extends AbstractRuleContext {
    private final Variable<A> variableA;
    private final Variable<B> variableB;
    private final Variable<C> variableC;
    private final Variable<D> variableD;

    public QuadRuleContext(Variable<A> variableA, Variable<B> variableB, Variable<C> variableC, Variable<D> variableD, ViewItem<?> ... viewItems) {
        super(viewItems);
        this.variableA = Objects.requireNonNull(variableA);
        this.variableB = Objects.requireNonNull(variableB);
        this.variableC = Objects.requireNonNull(variableC);
        this.variableD = Objects.requireNonNull(variableD);
    }

    public <Solution_> RuleBuilder<Solution_> newRuleBuilder(ToIntQuadFunction<A, B, C, D> matchWeighter) {
        ConsequenceBuilder consequenceBuilder = (constraint, scoreHolderGlobal) -> DSL.on((Variable)scoreHolderGlobal, this.variableA, this.variableB, this.variableC, this.variableD).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> QuadRuleContext.impactScore(constraint, drools, scoreHolder, matchWeighter.applyAsInt(a, b, c, d), a, b, c, d));
        return this.assemble(consequenceBuilder);
    }

    public <Solution_> RuleBuilder<Solution_> newRuleBuilder(ToLongQuadFunction<A, B, C, D> matchWeighter) {
        ConsequenceBuilder consequenceBuilder = (constraint, scoreHolderGlobal) -> DSL.on((Variable)scoreHolderGlobal, this.variableA, this.variableB, this.variableC, this.variableD).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> QuadRuleContext.impactScore(constraint, drools, scoreHolder, matchWeighter.applyAsLong(a, b, c, d), a, b, c, d));
        return this.assemble(consequenceBuilder);
    }

    public <Solution_> RuleBuilder<Solution_> newRuleBuilder(QuadFunction<A, B, C, D, BigDecimal> matchWeighter) {
        ConsequenceBuilder consequenceBuilder = (constraint, scoreHolderGlobal) -> DSL.on((Variable)scoreHolderGlobal, this.variableA, this.variableB, this.variableC, this.variableD).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> QuadRuleContext.impactScore(constraint, drools, scoreHolder, (BigDecimal)matchWeighter.apply(a, b, c, d), a, b, c, d));
        return this.assemble(consequenceBuilder);
    }

    public <Solution_> RuleBuilder<Solution_> newRuleBuilder() {
        ConsequenceBuilder consequenceBuilder = (constraint, scoreHolderGlobal) -> DSL.on((Variable)scoreHolderGlobal, this.variableA, this.variableB, this.variableC, this.variableD).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> QuadRuleContext.impactScore(drools, scoreHolder, a, b, c, d));
        return this.assemble(consequenceBuilder);
    }
}

