/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.drools.model.BetaIndex;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.FilteringBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.NoneBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DetachedPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.DirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.IndirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.QuadLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.QuadRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.RuleBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.TriLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.TriRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.UniAccumulateFunction;
import org.optaplanner.core.impl.score.stream.drools.common.UniRuleContext;

public final class UniLeftHandSide<A>
extends AbstractLeftHandSide {
    private final PatternVariable<A, ?, ?> patternVariable;
    private final UniRuleContext<A> ruleContext;

    public UniLeftHandSide(Class<A> aClass, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariable = new DirectPatternVariable(variableFactory.createVariable(aClass, "var"));
        this.ruleContext = this.buildDefaultRuleContext();
    }

    protected UniLeftHandSide(UniLeftHandSide<A> leftHandSide, PatternVariable<A, ?, ?> patternVariable) {
        super(leftHandSide.variableFactory);
        this.patternVariable = patternVariable;
        this.ruleContext = this.buildDefaultRuleContext();
    }

    protected UniLeftHandSide(UniRuleContext<A> ruleContext, PatternVariable<A, ?, ?> patternVariable, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariable = patternVariable;
        this.ruleContext = Objects.requireNonNull(ruleContext);
    }

    private UniRuleContext<A> buildDefaultRuleContext() {
        return new UniRuleContext<A>(this.patternVariable.getPrimaryVariable(), this.patternVariable.build().toArray(new ViewItem[0]));
    }

    protected PatternVariable<A, ?, ?> getPatternVariableA() {
        return this.patternVariable;
    }

    public UniLeftHandSide<A> andFilter(Predicate<A> predicate) {
        return new UniLeftHandSide<A>(this, this.patternVariable.filter(predicate));
    }

    private <B> UniLeftHandSide<A> applyJoiners(Class<B> otherFactType, AbstractBiJoiner<A, B> joiner, BiPredicate<A, B> predicate, boolean shouldExist) {
        Variable<B> toExist = this.variableFactory.createVariable(otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        JoinerType[] joinerTypes = joiner.getJoinerTypes();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            Function leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate2 & Serializable joinPredicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(leftMapping.apply(a), rightMapping.apply(b));
            BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)UniLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply);
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, this.patternVariable.getPrimaryVariable(), (Predicate2)joinPredicate, index);
        }
        return this.applyFilters(existencePattern, predicate, shouldExist);
    }

    private <B> UniLeftHandSide<A> applyFilters(PatternDSL.PatternDef<B> existencePattern, BiPredicate<A, B> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, this.patternVariable.getPrimaryVariable(), (Predicate2 & Serializable)(b, a) -> predicate.test(a, b));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new UniLeftHandSide<A>(this, this.patternVariable.addDependentExpression((ViewItem<?>)existenceExpression));
    }

    private <B> UniLeftHandSide<A> existsOrNot(Class<B> bClass, BiJoiner<A, B>[] joiners, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        AbstractBiJoiner finalJoiner = null;
        BiPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractBiJoiner biJoiner = (AbstractBiJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (biJoiner instanceof NoneBiJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneBiJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(biJoiner instanceof FilteringBiJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + biJoiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? biJoiner : AbstractBiJoiner.merge(finalJoiner, biJoiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? biJoiner.getFilter() : finalFilter.and(biJoiner.getFilter());
        }
        return this.applyJoiners(bClass, finalJoiner, finalFilter, shouldExist);
    }

    public <B> UniLeftHandSide<A> andExists(Class<B> bClass, BiJoiner<A, B>[] joiners) {
        return this.existsOrNot(bClass, joiners, true);
    }

    public <B> UniLeftHandSide<A> andNotExists(Class<B> bClass, BiJoiner<A, B>[] joiners) {
        return this.existsOrNot(bClass, joiners, false);
    }

    public <B> BiLeftHandSide<A, B> andJoin(UniLeftHandSide<B> right, BiJoiner<A, B> joiner) {
        AbstractBiJoiner castJoiner = (AbstractBiJoiner)joiner;
        JoinerType[] joinerTypes = castJoiner.getJoinerTypes();
        PatternVariable<A, ?, ?> newRight = right.patternVariable;
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            newRight = newRight.filterForJoin(this.patternVariable.getPrimaryVariable(), castJoiner, joinerType, mappingIndex);
        }
        return new BiLeftHandSide<A, A>(this.patternVariable, newRight, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(UniConstraintCollector<A, ?, NewA> collector) {
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> innerAccumulatePattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collector, accumulateOutput), (AccumulateFunction[])new AccumulateFunction[0]);
        UniRuleContext simpleRuleContext = new UniRuleContext(accumulateOutput, new ViewItem[]{outerAccumulatePattern});
        return new UniLeftHandSide(simpleRuleContext, new DirectPatternVariable(accumulateOutput, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(UniConstraintCollector<A, ?, NewA> collectorA, UniConstraintCollector<A, ?, NewB> collectorB) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        ViewItem<?> innerAccumulatePattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateOutputB)});
        BiRuleContext simpleRuleContext = new BiRuleContext(accumulateOutputA, accumulateOutputB, new ViewItem[]{outerAccumulatePattern});
        return new BiLeftHandSide(simpleRuleContext, new DetachedPatternVariable(accumulateOutputA), new DirectPatternVariable(accumulateOutputB, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(UniConstraintCollector<A, ?, NewA> collectorA, UniConstraintCollector<A, ?, NewB> collectorB, UniConstraintCollector<A, ?, NewC> collectorC) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        ViewItem<?> innerAccumulatePattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC)});
        TriRuleContext simpleRuleContext = new TriRuleContext(accumulateOutputA, accumulateOutputB, accumulateOutputC, new ViewItem[]{outerAccumulatePattern});
        return new TriLeftHandSide(simpleRuleContext, new DetachedPatternVariable(accumulateOutputA), new DetachedPatternVariable(accumulateOutputB), new DirectPatternVariable(accumulateOutputC, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(UniConstraintCollector<A, ?, NewA> collectorA, UniConstraintCollector<A, ?, NewB> collectorB, UniConstraintCollector<A, ?, NewC> collectorC, UniConstraintCollector<A, ?, NewD> collectorD) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        Variable accumulateOutputD = this.variableFactory.createVariable("collectedD");
        ViewItem<?> innerAccumulatePattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collectorA, accumulateOutputA), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD)});
        QuadRuleContext simpleRuleContext = new QuadRuleContext(accumulateOutputA, accumulateOutputB, accumulateOutputC, accumulateOutputD, new ViewItem[]{outerAccumulatePattern});
        return new QuadLeftHandSide(simpleRuleContext, new DetachedPatternVariable(accumulateOutputA), new DetachedPatternVariable(accumulateOutputB), new DetachedPatternVariable(accumulateOutputC), new DirectPatternVariable(accumulateOutputD, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(UniConstraintCollector<A, ?, Out> collector, Variable<Out> out) {
        return DSL.accFunction(() -> new UniAccumulateFunction(collector), this.patternVariable.getPrimaryVariable()).as(out);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(Function<A, NewA> keyMapping) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, keyMapping::apply, (AccumulateFunction[])new AccumulateFunction[0]);
        UniRuleContext simpleRuleContext = new UniRuleContext(groupKey, new ViewItem[]{groupByPattern});
        return new UniLeftHandSide(simpleRuleContext, new DirectPatternVariable(groupKey, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(Function<A, NewA> keyMappingA, UniConstraintCollector<A, ?, NewB> collectorB) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateOutput)});
        BiRuleContext simpleRuleContext = new BiRuleContext(groupKey, accumulateOutput, new ViewItem[]{groupByPattern});
        return new BiLeftHandSide(simpleRuleContext, new DetachedPatternVariable(groupKey), new DirectPatternVariable(accumulateOutput, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(Function<A, NewA> keyMappingA, UniConstraintCollector<A, ?, NewB> collectorB, UniConstraintCollector<A, ?, NewC> collectorC) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC)});
        TriRuleContext simpleRuleContext = new TriRuleContext(groupKey, accumulateOutputB, accumulateOutputC, new ViewItem[]{groupByPattern});
        return new TriLeftHandSide(simpleRuleContext, new DetachedPatternVariable(groupKey), new DetachedPatternVariable(accumulateOutputB), new DirectPatternVariable(accumulateOutputC, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(Function<A, NewA> keyMappingA, UniConstraintCollector<A, ?, NewB> collectorB, UniConstraintCollector<A, ?, NewC> collectorC, UniConstraintCollector<A, ?, NewD> collectorD) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD)});
        QuadRuleContext simpleRuleContext = new QuadRuleContext(groupKey, accumulateOutputB, accumulateOutputC, accumulateOutputD, new ViewItem[]{groupByPattern});
        return new QuadLeftHandSide(simpleRuleContext, new DetachedPatternVariable(groupKey), new DetachedPatternVariable(accumulateOutputB), new DetachedPatternVariable(accumulateOutputC), new DirectPatternVariable(accumulateOutputD, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, (Function1 & Serializable)a -> new BiTuple(keyMappingA.apply(a), keyMappingB.apply(a)), (AccumulateFunction[])new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        PatternVariable groupKeyPatternVar = ((DirectPatternVariable)new DirectPatternVariable<BiTuple>(groupKey, Collections.singletonList(groupByPattern)).bind(newA, tuple -> tuple.a)).bind(newB, tuple -> tuple.b);
        IndirectPatternVariable<Object, BiTuple> bPatternVar = new IndirectPatternVariable<Object, BiTuple>((DirectPatternVariable<BiTuple>)groupKeyPatternVar, (Variable<Object>)newB, tuple -> tuple.b);
        return new BiLeftHandSide(new DetachedPatternVariable(newA), bPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB, UniConstraintCollector<A, ?, NewC> collectorC) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, (Function1 & Serializable)a -> new BiTuple(keyMappingA.apply(a), keyMappingB.apply(a)), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateOutput)});
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        PatternVariable directPatternVariable = ((DirectPatternVariable)new DirectPatternVariable<BiTuple>(groupKey, Collections.singletonList(groupByPattern)).bind(newA, tuple -> tuple.a)).bind(newB, tuple -> tuple.b);
        List<ViewItem<?>> prerequisites = ((DirectPatternVariable)directPatternVariable).build();
        return new TriLeftHandSide(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DirectPatternVariable(accumulateOutput, prerequisites), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB, UniConstraintCollector<A, ?, NewC> collectorC, UniConstraintCollector<A, ?, NewD> collectorD) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, (Function1 & Serializable)a -> new BiTuple(keyMappingA.apply(a), keyMappingB.apply(a)), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD)});
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        PatternVariable directPatternVariable = ((DirectPatternVariable)new DirectPatternVariable<BiTuple>(groupKey, Collections.singletonList(groupByPattern)).bind(newA, tuple -> tuple.a)).bind(newB, tuple -> tuple.b);
        List<ViewItem<?>> prerequisites = ((DirectPatternVariable)directPatternVariable).build();
        return new QuadLeftHandSide(new DetachedPatternVariable(newA), new DetachedPatternVariable(newB), new DetachedPatternVariable(accumulateOutputC), new DirectPatternVariable(accumulateOutputD, prerequisites), this.variableFactory);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate() {
        return this.ruleContext.newRuleBuilder();
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToIntFunction<A> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToLongFunction<A> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(Function<A, BigDecimal> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }
}

