/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;
import org.optaplanner.swing.impl.TangoColorFactory;

public class NQueensPanel
extends SolutionPanel<NQueens> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/nqueens/swingui/nqueensLogo.png";
    private static final String QUEEN_IMAGE_PATH = "/org/optaplanner/examples/nqueens/swingui/queenImage.png";
    private ImageIcon queenImageIcon;

    public NQueensPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.BLACK);
        this.queenImageIcon = new ImageIcon(this.getClass().getResource(QUEEN_IMAGE_PATH));
    }

    @Override
    public void resetPanel(NQueens nQueens) {
        this.removeAll();
        this.repaint();
        int n = nQueens.getN();
        if (n > 100) {
            JLabel tooBigToShowLabel = new JLabel("The dataset is too big to show.");
            tooBigToShowLabel.setForeground(Color.WHITE);
            this.add(tooBigToShowLabel);
            return;
        }
        List<Queen> queenList = nQueens.getQueenList();
        this.setLayout(new GridLayout(n, n));
        for (int row = 0; row < n; ++row) {
            for (int column = 0; column < n; ++column) {
                Queen queen = queenList.get(column);
                if (queen.getColumn().getIndex() != column) {
                    throw new IllegalStateException("The queenList is not in the expected order.");
                }
                String toolTip = "<html>Row " + row + "<br/>Column " + column + "</html>";
                if (queen.getRow() != null && queen.getRow().getIndex() == row) {
                    JButton button = new JButton(new QueenAction(queen));
                    button.setMinimumSize(new Dimension(20, 20));
                    button.setPreferredSize(new Dimension(20, 20));
                    button.setToolTipText(toolTip);
                    this.add(button);
                    continue;
                }
                JPanel panel = new JPanel();
                panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_6), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
                Color background = (row + column) % 2 == 0 ? Color.WHITE : TangoColorFactory.ALUMINIUM_3;
                panel.setBackground(background);
                panel.setToolTipText(toolTip);
                this.add(panel);
            }
        }
    }

    private class QueenAction
    extends AbstractAction {
        private Queen queen;

        public QueenAction(Queen queen) {
            super(null, NQueensPanel.this.queenImageIcon);
            this.queen = queen;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel messagePanel = new JPanel(new BorderLayout());
            messagePanel.add((Component)new JLabel("Move to row: "), "West");
            List<Row> rowList = ((NQueens)NQueensPanel.this.getSolution()).getRowList();
            JComboBox<Object> rowListField = new JComboBox<Object>(rowList.toArray(new Object[rowList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(rowListField);
            rowListField.setSelectedItem(this.queen.getRow());
            messagePanel.add(rowListField, "Center");
            int result = JOptionPane.showConfirmDialog(NQueensPanel.this.getRootPane(), messagePanel, "Queen in column " + this.queen.getColumn().getIndex(), 2);
            if (result == 0) {
                Row toRow = (Row)rowListField.getSelectedItem();
                NQueensPanel.this.solutionBusiness.doChangeMove(this.queen, "row", toRow);
                NQueensPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

