/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.blueprint.SolverBenchmarkBluePrintConfig;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.SolverBenchmarkFactory;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.report.BenchmarkReportFactory;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.solver.thread.DefaultSolverThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlannerBenchmarkFactory
extends PlannerBenchmarkFactory {
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("(?U)^[\\w\\d _\\-\\.\\(\\)]+$");
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPlannerBenchmarkFactory.class);
    protected final PlannerBenchmarkConfig plannerBenchmarkConfig;

    public DefaultPlannerBenchmarkFactory(PlannerBenchmarkConfig plannerBenchmarkConfig) {
        if (plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + plannerBenchmarkConfig + ") cannot be null.");
        }
        this.plannerBenchmarkConfig = plannerBenchmarkConfig;
    }

    @Override
    public PlannerBenchmark buildPlannerBenchmark() {
        return this.buildPlannerBenchmark(new Object[0]);
    }

    @Override
    @SafeVarargs
    public final <Solution_> PlannerBenchmark buildPlannerBenchmark(Solution_ ... problems) {
        this.validate();
        this.generateSolverBenchmarkConfigNames();
        List<SolverBenchmarkConfig> effectiveSolverBenchmarkConfigList = this.buildEffectiveSolverBenchmarkConfigList();
        PlannerBenchmarkResult plannerBenchmarkResult = new PlannerBenchmarkResult();
        plannerBenchmarkResult.setName(this.plannerBenchmarkConfig.getName());
        plannerBenchmarkResult.setAggregation(false);
        int parallelBenchmarkCount = this.resolveParallelBenchmarkCount();
        plannerBenchmarkResult.setParallelBenchmarkCount(parallelBenchmarkCount);
        plannerBenchmarkResult.setWarmUpTimeMillisSpentLimit((Long)ObjectUtils.defaultIfNull((Object)this.calculateWarmUpTimeMillisSpentLimit(), (Object)30L));
        plannerBenchmarkResult.setUnifiedProblemBenchmarkResultList(new ArrayList<ProblemBenchmarkResult>());
        plannerBenchmarkResult.setSolverBenchmarkResultList(new ArrayList<SolverBenchmarkResult>(effectiveSolverBenchmarkConfigList.size()));
        for (SolverBenchmarkConfig solverBenchmarkConfig : effectiveSolverBenchmarkConfigList) {
            SolverBenchmarkFactory solverBenchmarkFactory = new SolverBenchmarkFactory(solverBenchmarkConfig);
            solverBenchmarkFactory.buildSolverBenchmark(this.plannerBenchmarkConfig.getClassLoader(), plannerBenchmarkResult, problems);
        }
        BenchmarkReportConfig benchmarkReportConfig_ = this.plannerBenchmarkConfig.getBenchmarkReportConfig() == null ? new BenchmarkReportConfig() : this.plannerBenchmarkConfig.getBenchmarkReportConfig();
        BenchmarkReport benchmarkReport = new BenchmarkReportFactory(benchmarkReportConfig_).buildBenchmarkReport(plannerBenchmarkResult);
        return new DefaultPlannerBenchmark(plannerBenchmarkResult, this.plannerBenchmarkConfig.getBenchmarkDirectory(), this.buildExecutorService(parallelBenchmarkCount), this.buildExecutorService(parallelBenchmarkCount), benchmarkReport);
    }

    private ExecutorService buildExecutorService(int parallelBenchmarkCount) {
        Object threadFactory = this.plannerBenchmarkConfig.getThreadFactoryClass() != null ? (ThreadFactory)ConfigUtils.newInstance((Object)this.plannerBenchmarkConfig, (String)"threadFactoryClass", this.plannerBenchmarkConfig.getThreadFactoryClass()) : new DefaultSolverThreadFactory("BenchmarkThread");
        return Executors.newFixedThreadPool(parallelBenchmarkCount, (ThreadFactory)threadFactory);
    }

    protected void validate() {
        if (this.plannerBenchmarkConfig.getName() != null) {
            if (!VALID_NAME_PATTERN.matcher(this.plannerBenchmarkConfig.getName()).matches()) {
                throw new IllegalStateException("The plannerBenchmark name (" + this.plannerBenchmarkConfig.getName() + ") is invalid because it does not follow the nameRegex (" + VALID_NAME_PATTERN.pattern() + ") which might cause an illegal filename.");
            }
            if (!this.plannerBenchmarkConfig.getName().trim().equals(this.plannerBenchmarkConfig.getName())) {
                throw new IllegalStateException("The plannerBenchmark name (" + this.plannerBenchmarkConfig.getName() + ") is invalid because it starts or ends with whitespace.");
            }
        }
        if (ConfigUtils.isEmptyCollection(this.plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList()) && ConfigUtils.isEmptyCollection(this.plannerBenchmarkConfig.getSolverBenchmarkConfigList())) {
            throw new IllegalArgumentException("Configure at least 1 <solverBenchmark> (or 1 <solverBenchmarkBluePrint>) in the <plannerBenchmark> configuration.");
        }
    }

    protected void generateSolverBenchmarkConfigNames() {
        if (this.plannerBenchmarkConfig.getSolverBenchmarkConfigList() != null) {
            HashSet<String> nameSet = new HashSet<String>(this.plannerBenchmarkConfig.getSolverBenchmarkConfigList().size());
            LinkedHashSet<SolverBenchmarkConfig> noNameBenchmarkConfigSet = new LinkedHashSet<SolverBenchmarkConfig>(this.plannerBenchmarkConfig.getSolverBenchmarkConfigList().size());
            for (SolverBenchmarkConfig solverBenchmarkConfig : this.plannerBenchmarkConfig.getSolverBenchmarkConfigList()) {
                if (solverBenchmarkConfig.getName() != null) {
                    boolean unique = nameSet.add(solverBenchmarkConfig.getName());
                    if (unique) continue;
                    throw new IllegalStateException("The benchmark name (" + solverBenchmarkConfig.getName() + ") is used in more than 1 benchmark.");
                }
                noNameBenchmarkConfigSet.add(solverBenchmarkConfig);
            }
            int generatedNameIndex = 0;
            for (SolverBenchmarkConfig solverBenchmarkConfig : noNameBenchmarkConfigSet) {
                String generatedName = "Config_" + generatedNameIndex;
                while (nameSet.contains(generatedName)) {
                    generatedName = "Config_" + ++generatedNameIndex;
                }
                solverBenchmarkConfig.setName(generatedName);
                ++generatedNameIndex;
            }
        }
    }

    protected List<SolverBenchmarkConfig> buildEffectiveSolverBenchmarkConfigList() {
        ArrayList<SolverBenchmarkConfig> effectiveSolverBenchmarkConfigList = new ArrayList<SolverBenchmarkConfig>(0);
        if (this.plannerBenchmarkConfig.getSolverBenchmarkConfigList() != null) {
            effectiveSolverBenchmarkConfigList.addAll(this.plannerBenchmarkConfig.getSolverBenchmarkConfigList());
        }
        if (this.plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList() != null) {
            for (SolverBenchmarkBluePrintConfig solverBenchmarkBluePrintConfig : this.plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList()) {
                effectiveSolverBenchmarkConfigList.addAll(solverBenchmarkBluePrintConfig.buildSolverBenchmarkConfigList());
            }
        }
        if (this.plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig() != null) {
            for (SolverBenchmarkConfig solverBenchmarkConfig : effectiveSolverBenchmarkConfigList) {
                solverBenchmarkConfig.inherit(this.plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig());
            }
        }
        return effectiveSolverBenchmarkConfigList;
    }

    protected int resolveParallelBenchmarkCount() {
        int availableProcessorCount = Runtime.getRuntime().availableProcessors();
        int resolvedParallelBenchmarkCount = this.plannerBenchmarkConfig.getParallelBenchmarkCount() == null ? 1 : (this.plannerBenchmarkConfig.getParallelBenchmarkCount().equals("AUTO") ? this.resolveParallelBenchmarkCountAutomatically(availableProcessorCount) : ConfigUtils.resolvePoolSize((String)"parallelBenchmarkCount", (String)this.plannerBenchmarkConfig.getParallelBenchmarkCount(), (String[])new String[]{"AUTO"}));
        if (resolvedParallelBenchmarkCount < 1) {
            throw new IllegalArgumentException("The parallelBenchmarkCount (" + this.plannerBenchmarkConfig.getParallelBenchmarkCount() + ") resulted in a resolvedParallelBenchmarkCount (" + resolvedParallelBenchmarkCount + ") that is lower than 1.");
        }
        if (resolvedParallelBenchmarkCount > availableProcessorCount) {
            LOGGER.warn("Because the resolvedParallelBenchmarkCount ({}) is higher than the availableProcessorCount ({}), it is reduced to availableProcessorCount.", (Object)resolvedParallelBenchmarkCount, (Object)availableProcessorCount);
            resolvedParallelBenchmarkCount = availableProcessorCount;
        }
        return resolvedParallelBenchmarkCount;
    }

    protected int resolveParallelBenchmarkCountAutomatically(int availableProcessorCount) {
        if (availableProcessorCount <= 2) {
            return 1;
        }
        if (availableProcessorCount <= 4) {
            return 2;
        }
        return availableProcessorCount / 2 + 1;
    }

    protected Long calculateWarmUpTimeMillisSpentLimit() {
        if (this.plannerBenchmarkConfig.getWarmUpMillisecondsSpentLimit() == null && this.plannerBenchmarkConfig.getWarmUpSecondsSpentLimit() == null && this.plannerBenchmarkConfig.getWarmUpMinutesSpentLimit() == null && this.plannerBenchmarkConfig.getWarmUpHoursSpentLimit() == null && this.plannerBenchmarkConfig.getWarmUpDaysSpentLimit() == null) {
            return null;
        }
        long warmUpTimeMillisSpentLimit = 0L;
        if (this.plannerBenchmarkConfig.getWarmUpMillisecondsSpentLimit() != null) {
            if (this.plannerBenchmarkConfig.getWarmUpMillisecondsSpentLimit() < 0L) {
                throw new IllegalArgumentException("The warmUpMillisecondsSpentLimit (" + this.plannerBenchmarkConfig.getWarmUpMillisecondsSpentLimit() + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.plannerBenchmarkConfig.getWarmUpMillisecondsSpentLimit().longValue();
        }
        if (this.plannerBenchmarkConfig.getWarmUpSecondsSpentLimit() != null) {
            if (this.plannerBenchmarkConfig.getWarmUpSecondsSpentLimit() < 0L) {
                throw new IllegalArgumentException("The warmUpSecondsSpentLimit (" + this.plannerBenchmarkConfig.getWarmUpSecondsSpentLimit() + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.plannerBenchmarkConfig.getWarmUpSecondsSpentLimit() * 1000L;
        }
        if (this.plannerBenchmarkConfig.getWarmUpMinutesSpentLimit() != null) {
            if (this.plannerBenchmarkConfig.getWarmUpMinutesSpentLimit() < 0L) {
                throw new IllegalArgumentException("The warmUpMinutesSpentLimit (" + this.plannerBenchmarkConfig.getWarmUpMinutesSpentLimit() + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.plannerBenchmarkConfig.getWarmUpMinutesSpentLimit() * 60000L;
        }
        if (this.plannerBenchmarkConfig.getWarmUpHoursSpentLimit() != null) {
            if (this.plannerBenchmarkConfig.getWarmUpHoursSpentLimit() < 0L) {
                throw new IllegalArgumentException("The warmUpHoursSpentLimit (" + this.plannerBenchmarkConfig.getWarmUpHoursSpentLimit() + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.plannerBenchmarkConfig.getWarmUpHoursSpentLimit() * 3600000L;
        }
        if (this.plannerBenchmarkConfig.getWarmUpDaysSpentLimit() != null) {
            if (this.plannerBenchmarkConfig.getWarmUpDaysSpentLimit() < 0L) {
                throw new IllegalArgumentException("The warmUpDaysSpentLimit (" + this.plannerBenchmarkConfig.getWarmUpDaysSpentLimit() + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.plannerBenchmarkConfig.getWarmUpDaysSpentLimit() * 86400000L;
        }
        return warmUpTimeMillisSpentLimit;
    }
}

