/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablelong;

import java.util.Arrays;
import java.util.Objects;
import org.optaplanner.core.api.score.AbstractBendableScore;

public final class BendableLongScore
extends AbstractBendableScore<BendableLongScore> {
    private final long[] hardScores;
    private final long[] softScores;

    public static BendableLongScore parseScore(String scoreString) {
        String[][] scoreTokens = BendableLongScore.parseBendableScoreTokens(BendableLongScore.class, scoreString);
        int initScore = BendableLongScore.parseInitScore(BendableLongScore.class, scoreString, scoreTokens[0][0]);
        long[] hardScores = new long[scoreTokens[1].length];
        for (int i = 0; i < hardScores.length; ++i) {
            hardScores[i] = BendableLongScore.parseLevelAsLong(BendableLongScore.class, scoreString, scoreTokens[1][i]);
        }
        long[] softScores = new long[scoreTokens[2].length];
        for (int i = 0; i < softScores.length; ++i) {
            softScores[i] = BendableLongScore.parseLevelAsLong(BendableLongScore.class, scoreString, scoreTokens[2][i]);
        }
        return BendableLongScore.ofUninitialized(initScore, hardScores, softScores);
    }

    public static BendableLongScore ofUninitialized(int initScore, long[] hardScores, long[] softScores) {
        return new BendableLongScore(initScore, hardScores, softScores);
    }

    public static BendableLongScore of(long[] hardScores, long[] softScores) {
        return new BendableLongScore(0, hardScores, softScores);
    }

    public static BendableLongScore zero(int hardLevelsSize, int softLevelsSize) {
        return new BendableLongScore(0, new long[hardLevelsSize], new long[softLevelsSize]);
    }

    public static BendableLongScore ofHard(int hardLevelsSize, int softLevelsSize, int hardLevel, long hardScore) {
        long[] hardScores = new long[hardLevelsSize];
        hardScores[hardLevel] = hardScore;
        return new BendableLongScore(0, hardScores, new long[softLevelsSize]);
    }

    public static BendableLongScore ofSoft(int hardLevelsSize, int softLevelsSize, int softLevel, long softScore) {
        long[] softScores = new long[softLevelsSize];
        softScores[softLevel] = softScore;
        return new BendableLongScore(0, new long[hardLevelsSize], softScores);
    }

    private BendableLongScore() {
        super(Integer.MIN_VALUE);
        this.hardScores = null;
        this.softScores = null;
    }

    protected BendableLongScore(int initScore, long[] hardScores, long[] softScores) {
        super(initScore);
        this.hardScores = hardScores;
        this.softScores = softScores;
    }

    public long[] getHardScores() {
        return Arrays.copyOf(this.hardScores, this.hardScores.length);
    }

    public long[] getSoftScores() {
        return Arrays.copyOf(this.softScores, this.softScores.length);
    }

    @Override
    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public long getHardScore(int index) {
        return this.hardScores[index];
    }

    @Override
    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public long getSoftScore(int index) {
        return this.softScores[index];
    }

    @Override
    public BendableLongScore withInitScore(int newInitScore) {
        return new BendableLongScore(newInitScore, this.hardScores, this.softScores);
    }

    @Override
    public int getLevelsSize() {
        return this.hardScores.length + this.softScores.length;
    }

    public long getHardOrSoftScore(int index) {
        if (index < this.hardScores.length) {
            return this.hardScores[index];
        }
        return this.softScores[index - this.hardScores.length];
    }

    @Override
    public boolean isFeasible() {
        if (this.initScore < 0) {
            return false;
        }
        for (long hardScore : this.hardScores) {
            if (hardScore >= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public BendableLongScore add(BendableLongScore addend) {
        int i;
        this.validateCompatible(addend);
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] + addend.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] + addend.getSoftScore(i);
        }
        return new BendableLongScore(this.initScore + addend.getInitScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore subtract(BendableLongScore subtrahend) {
        int i;
        this.validateCompatible(subtrahend);
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] - subtrahend.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] - subtrahend.getSoftScore(i);
        }
        return new BendableLongScore(this.initScore - subtrahend.getInitScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore multiply(double multiplicand) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor((double)this.hardScores[i] * multiplicand);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor((double)this.softScores[i] * multiplicand);
        }
        return new BendableLongScore((int)Math.floor((double)this.initScore * multiplicand), newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore divide(double divisor) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor((double)this.hardScores[i] / divisor);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor((double)this.softScores[i] / divisor);
        }
        return new BendableLongScore((int)Math.floor((double)this.initScore / divisor), newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore power(double exponent) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor(Math.pow(this.hardScores[i], exponent));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor(Math.pow(this.softScores[i], exponent));
        }
        return new BendableLongScore((int)Math.floor(Math.pow(this.initScore, exponent)), newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore negate() {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = -this.hardScores[i];
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = -this.softScores[i];
        }
        return new BendableLongScore(-this.initScore, newHardScores, newSoftScores);
    }

    @Override
    public Number[] toLevelNumbers() {
        int i;
        Number[] levelNumbers = new Number[this.hardScores.length + this.softScores.length];
        for (i = 0; i < this.hardScores.length; ++i) {
            levelNumbers[i] = this.hardScores[i];
        }
        for (i = 0; i < this.softScores.length; ++i) {
            levelNumbers[this.hardScores.length + i] = this.softScores[i];
        }
        return levelNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BendableLongScore) {
            int i;
            BendableLongScore other = (BendableLongScore)o;
            if (this.getHardLevelsSize() != other.getHardLevelsSize() || this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
                return false;
            }
            if (this.initScore != other.getInitScore()) {
                return false;
            }
            for (i = 0; i < this.hardScores.length; ++i) {
                if (this.hardScores[i] == other.getHardScore(i)) continue;
                return false;
            }
            for (i = 0; i < this.softScores.length; ++i) {
                if (this.softScores[i] == other.getSoftScore(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, Arrays.hashCode(this.hardScores), Arrays.hashCode(this.softScores));
    }

    @Override
    public int compareTo(BendableLongScore other) {
        int i;
        this.validateCompatible(other);
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            if (this.hardScores[i] == other.getHardScore(i)) continue;
            return Long.compare(this.hardScores[i], other.getHardScore(i));
        }
        for (i = 0; i < this.softScores.length; ++i) {
            if (this.softScores[i] == other.getSoftScore(i)) continue;
            return Long.compare(this.softScores[i], other.getSoftScore(i));
        }
        return 0;
    }

    @Override
    public String toShortString() {
        return this.buildBendableShortString(n -> (Long)n != 0L);
    }

    public String toString() {
        StringBuilder s = new StringBuilder((this.hardScores.length + this.softScores.length) * 4 + 13);
        s.append(this.getInitPrefix());
        s.append("[");
        boolean first = true;
        for (long hardScore : this.hardScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(hardScore);
        }
        s.append("]hard/[");
        first = true;
        for (long softScore : this.softScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(softScore);
        }
        s.append("]soft");
        return s.toString();
    }

    public void validateCompatible(BendableLongScore other) {
        if (this.getHardLevelsSize() != other.getHardLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with hardScoreSize (" + this.getHardLevelsSize() + ") is not compatible with the other score (" + other + ") with hardScoreSize (" + other.getHardLevelsSize() + ").");
        }
        if (this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with softScoreSize (" + this.getSoftLevelsSize() + ") is not compatible with the other score (" + other + ") with softScoreSize (" + other.getSoftLevelsSize() + ").");
        }
    }
}

