/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.ancompiler.KieBaseUpdaterANC;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.impl.ModelImpl;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.DirectFiringOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.OptaPlannerRuleEventListener;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;

public final class DroolsConstraintSessionFactory<Solution_, Score_ extends Score<Score_>> {
    private static final String SCORE_INLINER_GLOBAR_VAR_NAME = "scoreInliner";
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final List<DroolsConstraint<Solution_>> constraintList;
    private final boolean droolsAlphaNetworkCompilationEnabled;
    private KieBaseCache<Solution_, Score_> kieBaseCache = null;

    public DroolsConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, DroolsConstraintFactory<Solution_> constraintFactory, boolean droolsAlphaNetworkCompilationEnabled, Constraint ... constraints) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        this.constraintList = Arrays.stream(constraints).map(constraint -> {
            if (constraint.getConstraintFactory() != constraintFactory) {
                throw new IllegalStateException("Impossible state: The constraint (" + constraint.getConstraintId() + ") created by the wrong factory.");
            }
            return (DroolsConstraint)constraint;
        }).collect(Collectors.toList());
        this.droolsAlphaNetworkCompilationEnabled = droolsAlphaNetworkCompilationEnabled;
    }

    private static KieBase buildKieBaseFromModel(Model model, boolean droolsAlphaNetworkCompilationEnabled) {
        KieBaseConfiguration kieBaseConfiguration = KieServices.get().newKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)KieBaseMutabilityOption.DISABLED);
        kieBaseConfiguration.setProperty("drools.propertySpecific", PropertySpecificOption.DISABLED.name());
        InternalKnowledgeBase kieBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseConfiguration)kieBaseConfiguration);
        if (droolsAlphaNetworkCompilationEnabled) {
            KieBaseUpdaterANC.generateAndSetInMemoryANC((KieBase)kieBase);
        }
        return kieBase;
    }

    private static KieSession buildKieSessionFromKieBase(KieBase kieBase) {
        KieSessionConfiguration config = KieServices.get().newKieSessionConfiguration();
        config.setOption((KieSessionOption)DirectFiringOption.YES);
        Environment environment = KieServices.get().newEnvironment();
        return kieBase.newKieSession(config, environment);
    }

    public boolean isDroolsAlphaNetworkCompilationEnabled() {
        return this.droolsAlphaNetworkCompilationEnabled;
    }

    public SessionDescriptor<Score_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        Object zeroScore = scoreDefinition.getZeroScore();
        Map<DroolsConstraint, Score> constraintToWeightMap = InnerConstraintFactory.extractConstraintToWeightMap(this.constraintList, c -> c.extractConstraintWeight(workingSolution), zeroScore);
        if (this.kieBaseCache == null || !this.kieBaseCache.isUpToDate(constraintToWeightMap)) {
            Package pack = this.solutionDescriptor.getSolutionClass().getPackage();
            String constraintPackageName = pack == null ? "" : pack.getName();
            AtomicInteger idCounter = new AtomicInteger(0);
            Map constraintToGlobalMap = constraintToWeightMap.keySet().stream().collect(Collectors.toMap(Function.identity(), c -> DSL.globalOf(WeightedScoreImpacter.class, (String)constraintPackageName, (String)("scoreImpacter" + idCounter.getAndIncrement()))));
            ModelImpl model = constraintToWeightMap.keySet().stream().map(constraint -> constraint.buildRule((Global<WeightedScoreImpacter>)((Global)constraintToGlobalMap.get(constraint)))).reduce(new ModelImpl(), ModelImpl::addRule, (m, key) -> m);
            constraintToGlobalMap.forEach((constraint, global) -> model.addGlobal(global));
            KieBase kieBase = DroolsConstraintSessionFactory.buildKieBaseFromModel((Model)model, this.droolsAlphaNetworkCompilationEnabled);
            this.kieBaseCache = new KieBaseCache(constraintToWeightMap, constraintToGlobalMap, kieBase);
        }
        KieSession kieSession = DroolsConstraintSessionFactory.buildKieSessionFromKieBase(this.kieBaseCache.getKieBase());
        ((RuleEventManager)kieSession).addEventListener((RuleEventListener)new OptaPlannerRuleEventListener());
        ScoreInliner<Score> scoreInliner = scoreDefinition.buildScoreInliner(constraintToWeightMap, constraintMatchEnabled);
        this.kieBaseCache.getConstraintToGlobalMap().forEach((constraint, global) -> kieSession.setGlobal(global.getName(), (Object)scoreInliner.buildWeightedScoreImpacter((Constraint)constraint)));
        return new SessionDescriptor<Score>(kieSession, scoreInliner);
    }

    public static final class KieBaseCache<Solution_, Score_ extends Score<Score_>> {
        private final Map<DroolsConstraint<Solution_>, Score_> constraintToWeightMap;
        private final Map<DroolsConstraint<Solution_>, Global<WeightedScoreImpacter>> constraintToGlobalMap;
        private final KieBase kieBase;

        public KieBaseCache(Map<DroolsConstraint<Solution_>, Score_> constraintToWeightMap, Map<DroolsConstraint<Solution_>, Global<WeightedScoreImpacter>> constraintToGlobalMap, KieBase kieBase) {
            this.constraintToWeightMap = Objects.requireNonNull(constraintToWeightMap);
            this.constraintToGlobalMap = Objects.requireNonNull(constraintToGlobalMap);
            this.kieBase = Objects.requireNonNull(kieBase);
        }

        public boolean isUpToDate(Map<DroolsConstraint<Solution_>, Score_> currentConstraintWeightMap) {
            return this.constraintToWeightMap.equals(currentConstraintWeightMap);
        }

        public Map<DroolsConstraint<Solution_>, Global<WeightedScoreImpacter>> getConstraintToGlobalMap() {
            return this.constraintToGlobalMap;
        }

        public KieBase getKieBase() {
            return this.kieBase;
        }
    }

    public static final class SessionDescriptor<Score_ extends Score<Score_>> {
        private final KieSession session;
        private final ScoreInliner<Score_> scoreInliner;

        public SessionDescriptor(KieSession session, ScoreInliner<Score_> scoreInliner) {
            this.session = session;
            this.scoreInliner = scoreInliner;
        }

        public KieSession getSession() {
            return this.session;
        }

        public ScoreInliner<Score_> getScoreInliner() {
            return this.scoreInliner;
        }
    }
}

