/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.bestsolutionmutation;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.File;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.YIntervalRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationStatisticPoint;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;

public class BestSolutionMutationProblemStatistic
extends ProblemStatistic {
    protected File graphFile = null;

    public BestSolutionMutationProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        super(problemBenchmarkResult, ProblemStatisticType.BEST_SOLUTION_MUTATION);
    }

    @Override
    public SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        return new BestSolutionMutationSubSingleStatistic(subSingleBenchmarkResult);
    }

    @Override
    public List<File> getGraphFileList() {
        return Collections.singletonList(this.graphFile);
    }

    @Override
    public void writeGraphFiles(BenchmarkReport benchmarkReport) {
        XYPlot plot = this.createPlot(benchmarkReport);
        int seriesIndex = 0;
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix()));
            YIntervalRenderer renderer = new YIntervalRenderer();
            if (singleBenchmarkResult.hasAllSuccess()) {
                BestSolutionMutationSubSingleStatistic subSingleStatistic = (BestSolutionMutationSubSingleStatistic)singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
                List points = subSingleStatistic.getPointList();
                for (BestSolutionMutationStatisticPoint point : points) {
                    long timeMillisSpent = point.getTimeMillisSpent();
                    long mutationCount = point.getMutationCount();
                    double yValue = mutationCount;
                    series.add((double)timeMillisSpent, (double)timeMillisSpent, (double)timeMillisSpent, yValue, yValue > 0.0 ? 0.0 : yValue, yValue > 0.0 ? yValue : 0.0);
                }
            }
            XYIntervalSeriesCollection dataset = new XYIntervalSeriesCollection();
            dataset.addSeries(series);
            plot.setDataset(seriesIndex, (XYDataset)dataset);
            if (singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            }
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        JFreeChart chart = new JFreeChart(this.problemBenchmarkResult.getName() + " best solution mutation statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.graphFile = this.writeChartToImageFile(chart, this.problemBenchmarkResult.getName() + "BestSolutionMutationStatistic");
    }

    private XYPlot createPlot(BenchmarkReport benchmarkReport) {
        Locale locale = benchmarkReport.getLocale();
        NumberAxis xAxis = new NumberAxis("Time spent");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpentNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Best solution mutation count");
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(true);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }
}

