/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.examples.common.experimental.api.Break;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.BreakImpl;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveDataImpl;
import org.optaplanner.examples.common.experimental.impl.MapValuesIterable;
import org.optaplanner.examples.common.experimental.impl.SequenceImpl;

public class ConsecutiveSetTree<ValueType_, PointType_ extends Comparable<PointType_>, DifferenceType_ extends Comparable<DifferenceType_>> {
    private final Function<ValueType_, PointType_> indexFunction;
    private final BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction;
    private final BiFunction<DifferenceType_, DifferenceType_, DifferenceType_> sumFunction;
    private final DifferenceType_ maxDifference;
    private final DifferenceType_ zeroDifference;
    private final Map<ValueType_, Integer> itemToCountMap;
    private final NavigableSet<ValueType_> itemSet;
    private final NavigableMap<ValueType_, SequenceImpl<ValueType_, DifferenceType_>> startItemToSequence;
    private final NavigableMap<ValueType_, BreakImpl<ValueType_, DifferenceType_>> startItemToPreviousBreak;
    private final MapValuesIterable<ValueType_, SequenceImpl<ValueType_, DifferenceType_>> sequenceList;
    private final MapValuesIterable<ValueType_, BreakImpl<ValueType_, DifferenceType_>> breakList;
    private final ConsecutiveDataImpl<ValueType_, DifferenceType_> consecutiveData;

    public ConsecutiveSetTree(Function<ValueType_, PointType_> indexFunction, BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction, BiFunction<DifferenceType_, DifferenceType_, DifferenceType_> sumFunction, DifferenceType_ maxDifference, DifferenceType_ zeroDifference) {
        this.indexFunction = indexFunction;
        this.differenceFunction = differenceFunction;
        this.sumFunction = sumFunction;
        this.maxDifference = maxDifference;
        this.zeroDifference = zeroDifference;
        Comparator<Object> comparator = Comparator.comparing(indexFunction).thenComparing(System::identityHashCode);
        this.itemToCountMap = new IdentityHashMap<ValueType_, Integer>();
        this.itemSet = new TreeSet<Object>(comparator);
        this.startItemToSequence = new TreeMap<Object, SequenceImpl<ValueType_, DifferenceType_>>(comparator);
        this.startItemToPreviousBreak = new TreeMap<Object, BreakImpl<ValueType_, DifferenceType_>>(comparator);
        this.consecutiveData = new ConsecutiveDataImpl(this);
        this.sequenceList = new MapValuesIterable<SequenceImpl<ValueType_, DifferenceType_>, SequenceImpl<SequenceImpl<ValueType_, DifferenceType_>, DifferenceType_>>(this.startItemToSequence);
        this.breakList = new MapValuesIterable<BreakImpl<ValueType_, DifferenceType_>, BreakImpl<BreakImpl<ValueType_, DifferenceType_>, DifferenceType_>>(this.startItemToPreviousBreak);
    }

    public Iterable<Sequence<ValueType_, DifferenceType_>> getConsecutiveSequences() {
        return this.sequenceList;
    }

    public Iterable<Break<ValueType_, DifferenceType_>> getBreaks() {
        return this.breakList;
    }

    public ConsecutiveInfo<ValueType_, DifferenceType_> getConsecutiveData() {
        return this.consecutiveData;
    }

    public boolean add(ValueType_ item) {
        int newCount = this.itemToCountMap.compute(item, (key, count) -> count == null ? 1 : count + 1);
        if (newCount > 1) {
            return true;
        }
        this.itemSet.add(item);
        ValueType_ firstBeforeItem = this.startItemToSequence.floorKey(item);
        Comparable itemIndex = (Comparable)this.indexFunction.apply(item);
        if (firstBeforeItem != null) {
            ValueType_ endOfBeforeSequenceItem = this.getEndItem(firstBeforeItem);
            Comparable endOfBeforeSequenceIndex = (Comparable)this.indexFunction.apply(endOfBeforeSequenceItem);
            if (this.isInNaturalOrderAndHashOrderIfEqual(itemIndex, item, endOfBeforeSequenceIndex, endOfBeforeSequenceItem)) {
                return true;
            }
            ValueType_ firstAfterItem = this.startItemToSequence.higherKey(item);
            if (firstAfterItem != null) {
                Comparable startOfAfterSequenceIndex = (Comparable)this.indexFunction.apply(firstAfterItem);
                this.addBetweenItems(item, itemIndex, firstBeforeItem, endOfBeforeSequenceItem, endOfBeforeSequenceIndex, firstAfterItem, startOfAfterSequenceIndex);
            } else {
                SequenceImpl prevBag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
                if (this.isFirstSuccessorOfSecond(itemIndex, item, endOfBeforeSequenceIndex, endOfBeforeSequenceItem)) {
                    prevBag.setEnd(item);
                } else {
                    SequenceImpl newBag = new SequenceImpl(this, item);
                    this.startItemToSequence.put(item, newBag);
                    this.startItemToPreviousBreak.put(item, new BreakImpl<ValueType_, Comparable>(prevBag, newBag, (Comparable)this.differenceFunction.apply(endOfBeforeSequenceIndex, itemIndex)));
                }
            }
        } else {
            ValueType_ firstAfterItem = this.startItemToSequence.higherKey(item);
            if (firstAfterItem != null) {
                Comparable startOfAfterSequenceIndex = (Comparable)this.indexFunction.apply(firstAfterItem);
                if (this.isFirstSuccessorOfSecond(startOfAfterSequenceIndex, firstAfterItem, itemIndex, item)) {
                    SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
                    afterBag.setStart(item);
                    this.startItemToSequence.put(item, afterBag);
                } else {
                    SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.get(firstAfterItem);
                    SequenceImpl newBag = new SequenceImpl(this, item);
                    this.startItemToSequence.put(item, newBag);
                    this.startItemToPreviousBreak.put(firstAfterItem, new BreakImpl<ValueType_, Comparable>(newBag, afterBag, (Comparable)this.differenceFunction.apply(itemIndex, startOfAfterSequenceIndex)));
                }
            } else {
                SequenceImpl newBag = new SequenceImpl(this, item);
                this.startItemToSequence.put(item, newBag);
            }
        }
        return true;
    }

    public boolean remove(ValueType_ item) {
        Integer currentCount = this.itemToCountMap.get(item);
        if (currentCount == null) {
            return false;
        }
        if (currentCount != 1) {
            this.itemToCountMap.put(item, currentCount - 1);
            return true;
        }
        this.itemToCountMap.remove(item);
        ValueType_ firstBeforeItem = this.startItemToSequence.floorKey(item);
        SequenceImpl bag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
        Object endItem = bag.getLastItem();
        this.itemSet.remove(item);
        if (bag.getFirstItem() == bag.getLastItem()) {
            this.startItemToSequence.remove(firstBeforeItem);
            BreakImpl removedBreak = (BreakImpl)this.startItemToPreviousBreak.remove(firstBeforeItem);
            Map.Entry<ValueType_, BreakImpl<ValueType_, DifferenceType_>> extendedBreakEntry = this.startItemToPreviousBreak.higherEntry(firstBeforeItem);
            if (extendedBreakEntry != null) {
                if (removedBreak != null) {
                    BreakImpl extendedBreak = extendedBreakEntry.getValue();
                    extendedBreak.setPreviousSequence(removedBreak.getPreviousSequence());
                    this.updateLengthOfBreak(extendedBreak);
                } else {
                    this.startItemToPreviousBreak.remove(extendedBreakEntry.getKey());
                }
            }
            return true;
        }
        return this.removeItemFromBag(bag, item, firstBeforeItem, endItem);
    }

    protected NavigableSet<ValueType_> getItemSet() {
        return this.itemSet;
    }

    protected void updateLengthOfBreak(BreakImpl<ValueType_, DifferenceType_> theBreak) {
        theBreak.setLength(this.getBreakLengthBetween(theBreak.getPreviousSequenceEnd(), theBreak.getNextSequenceStart()));
    }

    protected DifferenceType_ getSequenceLength(Sequence<ValueType_, DifferenceType_> sequence) {
        return (DifferenceType_)((Comparable)this.sumFunction.apply(this.maxDifference, (Comparable)this.differenceFunction.apply((Comparable)this.indexFunction.apply(sequence.getFirstItem()), (Comparable)this.indexFunction.apply(sequence.getLastItem()))));
    }

    protected DifferenceType_ getBreakLengthBetween(ValueType_ from, ValueType_ to) {
        return (DifferenceType_)((Comparable)this.differenceFunction.apply((Comparable)this.indexFunction.apply(from), (Comparable)this.indexFunction.apply(to)));
    }

    protected ValueType_ getEndItem(ValueType_ key) {
        return ((SequenceImpl)this.startItemToSequence.get(key)).getLastItem();
    }

    private <T extends Comparable<T>> boolean isInNaturalOrderAndHashOrderIfEqual(T a, ValueType_ aItem, T b, ValueType_ bItem) {
        int difference = a.compareTo(b);
        if (difference != 0) {
            return difference < 0;
        }
        return System.identityHashCode(aItem) - System.identityHashCode(bItem) < 0;
    }

    private boolean isFirstSuccessorOfSecond(PointType_ first, ValueType_ firstValue, PointType_ second, ValueType_ secondValue) {
        Comparable difference = (Comparable)this.differenceFunction.apply(second, first);
        return this.isInNaturalOrderAndHashOrderIfEqual((Comparable)this.zeroDifference, secondValue, (Comparable)difference, firstValue) && difference.compareTo(this.maxDifference) <= 0;
    }

    private void addBetweenItems(ValueType_ item, PointType_ itemIndex, ValueType_ firstBeforeItem, ValueType_ endOfBeforeSequenceItem, PointType_ endOfBeforeSequenceItemIndex, ValueType_ firstAfterItem, PointType_ startOfAfterSequenceIndex) {
        if (this.isFirstSuccessorOfSecond(itemIndex, item, endOfBeforeSequenceItemIndex, endOfBeforeSequenceItem)) {
            SequenceImpl prevBag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
            if (this.isFirstSuccessorOfSecond(startOfAfterSequenceIndex, firstAfterItem, itemIndex, item)) {
                this.startItemToPreviousBreak.remove(firstAfterItem);
                SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
                prevBag.merge(afterBag);
                Map.Entry<ValueType_, BreakImpl<ValueType_, DifferenceType_>> maybeNextBreak = this.startItemToPreviousBreak.higherEntry(firstAfterItem);
                if (maybeNextBreak != null) {
                    maybeNextBreak.getValue().setPreviousSequence(prevBag);
                }
            } else {
                prevBag.setEnd(item);
                BreakImpl nextBreak = (BreakImpl)this.startItemToPreviousBreak.get(firstAfterItem);
                nextBreak.setLength((Comparable)this.differenceFunction.apply(itemIndex, startOfAfterSequenceIndex));
            }
        } else if (this.isFirstSuccessorOfSecond(startOfAfterSequenceIndex, firstAfterItem, itemIndex, item)) {
            SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
            afterBag.setStart(item);
            this.startItemToSequence.put(item, afterBag);
            BreakImpl prevBreak = (BreakImpl)this.startItemToPreviousBreak.remove(firstAfterItem);
            prevBreak.setLength((Comparable)this.differenceFunction.apply(endOfBeforeSequenceItemIndex, itemIndex));
            this.startItemToPreviousBreak.put(item, prevBreak);
        } else {
            SequenceImpl newBag = new SequenceImpl(this, item);
            this.startItemToSequence.put(item, newBag);
            BreakImpl nextBreak = (BreakImpl)this.startItemToPreviousBreak.get(firstAfterItem);
            nextBreak.setPreviousSequence(newBag);
            nextBreak.setLength((Comparable)this.differenceFunction.apply(itemIndex, startOfAfterSequenceIndex));
            this.startItemToPreviousBreak.put(item, new BreakImpl<ValueType_, Comparable>((Sequence)this.startItemToSequence.get(firstBeforeItem), newBag, (Comparable)this.differenceFunction.apply(endOfBeforeSequenceItemIndex, itemIndex)));
        }
    }

    private boolean removeItemFromBag(SequenceImpl<ValueType_, DifferenceType_> bag, ValueType_ item, ValueType_ sequenceStart, ValueType_ sequenceEnd) {
        if (item.equals(sequenceStart)) {
            bag.setStart(this.itemSet.higher(item));
            this.startItemToSequence.remove(sequenceStart);
            BreakImpl extendedBreak = (BreakImpl)this.startItemToPreviousBreak.remove(sequenceStart);
            ValueType_ firstItem = bag.getFirstItem();
            this.startItemToSequence.put(firstItem, bag);
            if (extendedBreak != null) {
                this.updateLengthOfBreak(extendedBreak);
                this.startItemToPreviousBreak.put(firstItem, extendedBreak);
            }
            return true;
        }
        if (item.equals(sequenceEnd)) {
            bag.setEnd(this.itemSet.lower(item));
            Map.Entry<ValueType_, BreakImpl<ValueType_, DifferenceType_>> extendedBreakEntry = this.startItemToPreviousBreak.higherEntry(item);
            if (extendedBreakEntry != null) {
                BreakImpl<ValueType_, DifferenceType_> extendedBreak = extendedBreakEntry.getValue();
                this.updateLengthOfBreak(extendedBreak);
            }
            return true;
        }
        ValueType_ firstAfterItem = bag.getItems().higher(item);
        ValueType_ firstBeforeItem = bag.getItems().lower(item);
        if (this.isFirstSuccessorOfSecond((Comparable)this.indexFunction.apply(firstAfterItem), firstAfterItem, (Comparable)this.indexFunction.apply(firstBeforeItem), firstBeforeItem)) {
            return true;
        }
        SequenceImpl<ValueType_, DifferenceType_> splitBag = bag.split(item);
        ValueType_ firstSplitItem = splitBag.getFirstItem();
        ValueType_ lastOriginalItem = bag.getLastItem();
        this.startItemToSequence.put(firstSplitItem, splitBag);
        this.startItemToPreviousBreak.put(firstSplitItem, new BreakImpl<ValueType_, DifferenceType_>(bag, splitBag, this.getBreakLengthBetween(lastOriginalItem, firstSplitItem)));
        Map.Entry<ValueType_, BreakImpl<ValueType_, DifferenceType_>> maybeNextBreak = this.startItemToPreviousBreak.higherEntry(firstAfterItem);
        if (maybeNextBreak != null) {
            maybeNextBreak.getValue().setPreviousSequence(splitBag);
        }
        return true;
    }
}

