/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.optional.score;

import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.meetingscheduling.domain.Attendance;
import org.optaplanner.examples.meetingscheduling.domain.MeetingAssignment;
import org.optaplanner.examples.meetingscheduling.domain.PreferredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.RequiredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.Room;
import org.optaplanner.examples.meetingscheduling.domain.TimeGrain;

public class MeetingSchedulingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.roomConflict(constraintFactory), this.avoidOvertime(constraintFactory), this.requiredAttendanceConflict(constraintFactory), this.requiredRoomCapacity(constraintFactory), this.startAndEndOnSameDay(constraintFactory), this.requiredAndPreferredAttendanceConflict(constraintFactory), this.preferredAttendanceConflict(constraintFactory), this.doMeetingsAsSoonAsPossible(constraintFactory), this.oneBreakBetweenConsecutiveMeetings(constraintFactory), this.overlappingMeetings(constraintFactory), this.assignLargerRoomsFirst(constraintFactory), this.roomStability(constraintFactory)};
    }

    protected Constraint roomConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUnfiltered(MeetingAssignment.class).filter(leftAssignment -> leftAssignment.getRoom() != null).join(MeetingAssignment.class, Joiners.equal(MeetingAssignment::getRoom), Joiners.lessThan(AbstractPersistable::getId), Joiners.overlapping(assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains())).penalizeConfigurable("Room conflict", (leftAssignment, rightAssignment) -> rightAssignment.calculateOverlap((MeetingAssignment)leftAssignment));
    }

    protected Constraint avoidOvertime(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUnfiltered(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).ifNotExists(TimeGrain.class, Joiners.equal(MeetingAssignment::getLastTimeGrainIndex, TimeGrain::getGrainIndex)).penalizeConfigurable("Don't go in overtime", MeetingAssignment::getLastTimeGrainIndex);
    }

    protected Constraint requiredAttendanceConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUniquePair(RequiredAttendance.class, Joiners.equal(Attendance::getPerson)).join(MeetingAssignment.class, Joiners.equal((leftRequiredAttendance, rightRequiredAttendance) -> leftRequiredAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.filtering((leftRequiredAttendance, rightRequiredAttendance, leftAssignment) -> leftAssignment.getStartingTimeGrain() != null)).join(MeetingAssignment.class, Joiners.equal((leftRequiredAttendance, rightRequiredAttendance, leftAssignment) -> rightRequiredAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.overlapping((attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex(), (attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains(), assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains())).penalizeConfigurable("Required attendance conflict", (leftRequiredAttendance, rightRequiredAttendance, leftAssignment, rightAssignment) -> rightAssignment.calculateOverlap((MeetingAssignment)leftAssignment));
    }

    protected Constraint requiredRoomCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUnfiltered(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getRequiredCapacity() > meetingAssignment.getRoomCapacity()).penalizeConfigurable("Required room capacity", meetingAssignment -> meetingAssignment.getRequiredCapacity() - meetingAssignment.getRoomCapacity());
    }

    protected Constraint startAndEndOnSameDay(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUnfiltered(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).join(TimeGrain.class, Joiners.equal(MeetingAssignment::getLastTimeGrainIndex, TimeGrain::getGrainIndex), Joiners.filtering((meetingAssignment, timeGrain) -> meetingAssignment.getStartingTimeGrain().getDay() != timeGrain.getDay())).penalizeConfigurable("Start and end on same day");
    }

    protected Constraint requiredAndPreferredAttendanceConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.from(RequiredAttendance.class).join(PreferredAttendance.class, Joiners.equal(Attendance::getPerson, Attendance::getPerson)).join(MeetingAssignment.class, Joiners.equal((requiredAttendance, preferredAttendance) -> requiredAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.filtering((requiredAttendance, preferredAttendance, leftAssignment) -> leftAssignment.getStartingTimeGrain() != null)).join(MeetingAssignment.class, Joiners.equal((requiredAttendance, preferredAttendance, leftAssignment) -> preferredAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.overlapping((attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex(), (attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains(), assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains())).penalizeConfigurable("Required and preferred attendance conflict");
    }

    protected Constraint preferredAttendanceConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUniquePair(PreferredAttendance.class, Joiners.equal(Attendance::getPerson)).join(MeetingAssignment.class, Joiners.equal((leftAttendance, rightAttendance) -> leftAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.filtering((leftAttendance, rightAttendance, leftAssignment) -> leftAssignment.getStartingTimeGrain() != null)).join(MeetingAssignment.class, Joiners.equal((leftAttendance, rightAttendance, leftAssignment) -> rightAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.overlapping((attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex(), (attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains(), assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains())).penalizeConfigurable("Preferred attendance conflict");
    }

    protected Constraint doMeetingsAsSoonAsPossible(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUnfiltered(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).penalizeConfigurable("Do all meetings as soon as possible", MeetingAssignment::getLastTimeGrainIndex);
    }

    protected Constraint oneBreakBetweenConsecutiveMeetings(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUnfiltered(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).join(MeetingAssignment.class, Joiners.equal(MeetingAssignment::getLastTimeGrainIndex, rightAssignment -> rightAssignment.getStartingTimeGrain().getGrainIndex() - 1), Joiners.filtering((leftAssignment, rightAssignment) -> rightAssignment.getStartingTimeGrain() != null)).penalizeConfigurable("One TimeGrain break between two consecutive meetings");
    }

    protected Constraint overlappingMeetings(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUnfiltered(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).join(MeetingAssignment.class, Joiners.greaterThan(leftAssignment -> leftAssignment.getMeeting().getId(), rightAssignment -> rightAssignment.getMeeting().getId()), Joiners.overlapping(assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains()), Joiners.filtering((leftAssignment, rightAssignment) -> rightAssignment.getStartingTimeGrain() != null), Joiners.filtering((leftAssignment, rightAssignment) -> leftAssignment.getMeeting() != rightAssignment.getMeeting())).penalizeConfigurable("Overlapping meetings");
    }

    protected Constraint assignLargerRoomsFirst(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUnfiltered(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getRoom() != null).join(Room.class, Joiners.lessThan(MeetingAssignment::getRoomCapacity, Room::getCapacity)).penalizeConfigurable("Assign larger rooms first", (meetingAssignment, room) -> room.getCapacity() - meetingAssignment.getRoomCapacity());
    }

    protected Constraint roomStability(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Attendance.class).join(Attendance.class, Joiners.equal(Attendance::getPerson), Joiners.filtering((leftAttendance, rightAttendance) -> leftAttendance.getMeeting() != rightAttendance.getMeeting())).join(MeetingAssignment.class, Joiners.equal((leftAttendance, rightAttendance) -> leftAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.filtering((leftAttendance, rightAttendance, leftAssignment) -> leftAssignment.getStartingTimeGrain() != null)).join(MeetingAssignment.class, new QuadJoiner[]{Joiners.equal((leftAttendance, rightAttendance, leftAssignment) -> rightAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.lessThan((leftAttendance, rightAttendance, leftAssignment) -> leftAssignment.getStartingTimeGrain().getGrainIndex(), rightAssignment -> rightAssignment.getStartingTimeGrain().getGrainIndex()), Joiners.filtering((leftAttendance, rightAttendance, leftAssignment, rightAssignment) -> rightAssignment.getStartingTimeGrain() != null), Joiners.filtering((leftAttendance, rightAttendance, leftAssignment, rightAssignment) -> leftAssignment.getRoom() != rightAssignment.getRoom()), Joiners.filtering((leftAttendance, rightAttendance, leftAssignment, rightAssignment) -> rightAssignment.getStartingTimeGrain().getGrainIndex() - leftAttendance.getMeeting().getDurationInGrains() - leftAssignment.getStartingTimeGrain().getGrainIndex() <= 2)}).penalizeConfigurable("Room stability");
    }
}

