/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.jupiter.api.Assertions;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;

public abstract class AbstractScoreVerifier<Solution_> {
    protected final InnerScoreDirectorFactory<Solution_, ?> scoreDirectorFactory;

    public AbstractScoreVerifier(SolverFactory<Solution_> solverFactory, Class<? extends Score<?>> expectedScoreClass) {
        if (solverFactory == null) {
            throw new IllegalStateException("The solverFactory (" + solverFactory + ") cannot be null.");
        }
        this.scoreDirectorFactory = ((DefaultSolverFactory)solverFactory).getScoreDirectorFactory();
        SolutionDescriptor solutionDescriptor = this.scoreDirectorFactory.getSolutionDescriptor();
        Class scoreClass = solutionDescriptor.getScoreDefinition().getScoreClass();
        if (expectedScoreClass != scoreClass) {
            throw new IllegalStateException("The solution's scoreClass (" + scoreClass + ") differs from the test's expectedScoreClass (" + expectedScoreClass + ").");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assertWeight(String constraintPackage, String constraintName, int scoreLevel, Number expectedWeight, Solution_ solution) {
        ConstraintMatchTotal<?> matchTotal;
        try (InnerScoreDirector scoreDirector = this.scoreDirectorFactory.buildScoreDirector();){
            scoreDirector.setWorkingSolution(solution);
            scoreDirector.calculateScore();
            matchTotal = this.findConstraintMatchTotal(constraintPackage, constraintName, scoreDirector);
        }
        if (expectedWeight == null) {
            throw new IllegalArgumentException("The expectedWeight (" + expectedWeight + ") cannot be null, regardless of the matchTotal (" + matchTotal + ").");
        }
        if (matchTotal == null) {
            if (expectedWeight instanceof Byte) {
                Assertions.assertEquals((Object)expectedWeight, (Object)0);
                return;
            } else if (expectedWeight instanceof Short) {
                Assertions.assertEquals((Object)expectedWeight, (Object)0);
                return;
            } else if (expectedWeight instanceof Integer) {
                Assertions.assertEquals((Object)expectedWeight, (Object)0);
                return;
            } else if (expectedWeight instanceof Long) {
                Assertions.assertEquals((Object)expectedWeight, (Object)0L);
                return;
            } else if (expectedWeight instanceof Float) {
                Assertions.assertEquals((Object)expectedWeight, (Object)Float.valueOf(0.0f));
                return;
            } else if (expectedWeight instanceof Double) {
                Assertions.assertEquals((Object)expectedWeight, (Object)0.0);
                return;
            } else if (expectedWeight instanceof BigInteger) {
                Assertions.assertEquals((Object)expectedWeight, (Object)BigInteger.ZERO);
                return;
            } else {
                if (!(expectedWeight instanceof BigDecimal)) throw new IllegalStateException("Unsupported " + Number.class.getSimpleName() + " type (" + expectedWeight.getClass() + ") for expectedWeight (" + expectedWeight + ").");
                Assertions.assertEquals((Object)expectedWeight, (Object)BigDecimal.ZERO);
            }
            return;
        } else {
            Assertions.assertEquals((Object)expectedWeight, (Object)matchTotal.getScore().toLevelNumbers()[scoreLevel]);
        }
    }

    private ConstraintMatchTotal<?> findConstraintMatchTotal(String constraintPackage, String constraintName, InnerScoreDirector<Solution_, ?> scoreDirector) {
        if (constraintPackage != null) {
            String constraintId = ConstraintMatchTotal.composeConstraintId((String)constraintPackage, (String)constraintName);
            return (ConstraintMatchTotal)scoreDirector.getConstraintMatchTotalMap().get(constraintId);
        }
        ConstraintMatchTotal matchTotal = null;
        for (ConstraintMatchTotal selectedMatchTotal : scoreDirector.getConstraintMatchTotalMap().values()) {
            if (!selectedMatchTotal.getConstraintName().equals(constraintName)) continue;
            if (matchTotal != null) {
                throw new IllegalArgumentException("The constraintName (" + constraintName + ") is used by 2 different constraintMatches (" + matchTotal.getConstraintId() + " and " + selectedMatchTotal.getConstraintId() + ").");
            }
            matchTotal = selectedMatchTotal;
        }
        return matchTotal;
    }
}

