/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.impl.domain.common.AlphabeticMemberComparator;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;

public class ConfigUtils {
    private static final AlphabeticMemberComparator alphabeticMemberComparator = new AlphabeticMemberComparator();

    public static <T> T newInstance(Object configBean, String propertyName, Class<T> clazz) {
        return ConfigUtils.newInstance(() -> configBean == null ? "?" : configBean.getClass().getSimpleName(), propertyName, clazz);
    }

    public static <T> T newInstance(Supplier<String> ownerDescriptor, String propertyName, Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("The " + ownerDescriptor.get() + "'s " + propertyName + " (" + clazz.getName() + ") does not have a public no-arg constructor" + ((clazz.isLocalClass() || clazz.isAnonymousClass() || clazz.isMemberClass()) && !Modifier.isStatic(clazz.getModifiers()) ? " because it is an inner class." : "."), e);
        }
    }

    public static void applyCustomProperties(Object bean, String beanClassPropertyName, Map<String, String> customProperties, String customPropertiesPropertyName) {
        if (customProperties == null) {
            return;
        }
        Class<?> beanClass = bean.getClass();
        customProperties.forEach((propertyName, valueString) -> {
            Object typedValue;
            Method setterMethod;
            block14: {
                setterMethod = ReflectionHelper.getSetterMethod(beanClass, propertyName);
                if (setterMethod == null) {
                    throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " cannot be set on the " + beanClassPropertyName + " (" + beanClass + ") because that class has no public setter for that property.\nMaybe add a public setter for that custom property (" + propertyName + ") on that class (" + beanClass.getSimpleName() + ").\nMaybe don't configure that custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + ".");
                }
                Class<?> propertyType = setterMethod.getParameterTypes()[0];
                try {
                    if (propertyType.equals(String.class)) {
                        typedValue = valueString;
                        break block14;
                    }
                    if (propertyType.equals(Boolean.TYPE) || propertyType.equals(Boolean.class)) {
                        typedValue = Boolean.parseBoolean(valueString);
                        break block14;
                    }
                    if (propertyType.equals(Integer.TYPE) || propertyType.equals(Integer.class)) {
                        typedValue = Integer.parseInt(valueString);
                        break block14;
                    }
                    if (propertyType.equals(Long.TYPE) || propertyType.equals(Long.class)) {
                        typedValue = Long.parseLong(valueString);
                        break block14;
                    }
                    if (propertyType.equals(Float.TYPE) || propertyType.equals(Float.class)) {
                        typedValue = Float.valueOf(Float.parseFloat(valueString));
                        break block14;
                    }
                    if (propertyType.equals(Double.TYPE) || propertyType.equals(Double.class)) {
                        typedValue = Double.parseDouble(valueString);
                        break block14;
                    }
                    if (propertyType.equals(BigDecimal.class)) {
                        typedValue = new BigDecimal((String)valueString);
                        break block14;
                    }
                    if (propertyType.isEnum()) {
                        typedValue = Enum.valueOf(propertyType, valueString);
                        break block14;
                    }
                    throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " has an unsupported propertyType (" + propertyType + ") for value (" + valueString + ").");
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " cannot be parsed to the propertyType (" + propertyType + ") of the setterMethod (" + setterMethod + ").");
                }
            }
            try {
                setterMethod.invoke(bean, typedValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " has a setterMethod (" + setterMethod + ") on the beanClass (" + beanClass + ") that cannot be called for the typedValue (" + typedValue + ").", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " has a setterMethod (" + setterMethod + ") on the beanClass (" + beanClass + ") that throws an exception for the typedValue (" + typedValue + ").", e.getCause());
            }
        });
    }

    public static <Config_ extends AbstractConfig<Config_>> Config_ inheritConfig(Config_ original, Config_ inherited) {
        if (inherited != null) {
            if (original == null) {
                original = inherited.copyConfig();
            } else {
                original.inherit(inherited);
            }
        }
        return original;
    }

    public static <Config_ extends AbstractConfig<Config_>> List<Config_> inheritMergeableListConfig(List<Config_> originalList, List<Config_> inheritedList) {
        if (inheritedList != null) {
            ArrayList<Config_> mergedList = new ArrayList<Config_>(inheritedList.size() + (originalList == null ? 0 : originalList.size()));
            for (AbstractConfig inherited : inheritedList) {
                Object copy = inherited.copyConfig();
                mergedList.add(copy);
            }
            if (originalList != null) {
                mergedList.addAll(originalList);
            }
            originalList = mergedList;
        }
        return originalList;
    }

    public static <T> T inheritOverwritableProperty(T original, T inherited) {
        if (original != null) {
            return original;
        }
        return inherited;
    }

    public static <T> List<T> inheritMergeableListProperty(List<T> originalList, List<T> inheritedList) {
        if (inheritedList == null) {
            return originalList;
        }
        if (originalList == null) {
            return new ArrayList<T>(inheritedList);
        }
        ArrayList<T> mergedList = new ArrayList<T>(inheritedList);
        mergedList.addAll(originalList);
        return mergedList;
    }

    public static <K, T> Map<K, T> inheritMergeableMapProperty(Map<K, T> originalMap, Map<K, T> inheritedMap) {
        if (inheritedMap == null) {
            return originalMap;
        }
        if (originalMap == null) {
            return inheritedMap;
        }
        LinkedHashMap<K, T> mergedMap = new LinkedHashMap<K, T>(inheritedMap);
        mergedMap.putAll(originalMap);
        return mergedMap;
    }

    public static <T> T mergeProperty(T a, T b) {
        return (T)(Objects.equals(a, b) ? a : null);
    }

    public static <T> T meldProperty(T a, T b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null && b != null) {
            return b;
        }
        if (a != null && b == null) {
            return a;
        }
        return ConfigUtils.mergeProperty(a, b);
    }

    public static boolean isEmptyCollection(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static int ceilDivide(int dividend, int divisor) {
        if (divisor == 0) {
            throw new ArithmeticException("Cannot divide by zero: " + dividend + "/" + divisor);
        }
        int correction = dividend % divisor == 0 ? 0 : (Integer.signum(dividend) * Integer.signum(divisor) < 0 ? 0 : 1);
        return dividend / divisor + correction;
    }

    public static int resolvePoolSize(String propertyName, String value, String ... magicValues) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("The " + propertyName + " (" + value + ") resolved to neither of (" + Arrays.toString(magicValues) + ") nor a number.");
        }
    }

    public static List<Class<?>> getAllAnnotatedLineageClasses(Class<?> bottomClass, Class<? extends Annotation> annotation) {
        if (!bottomClass.isAnnotationPresent(annotation)) {
            return Collections.emptyList();
        }
        ArrayList lineageClassList = new ArrayList();
        lineageClassList.add(bottomClass);
        Class<?> superclass = bottomClass.getSuperclass();
        lineageClassList.addAll(ConfigUtils.getAllAnnotatedLineageClasses(superclass, annotation));
        for (Class<?> superInterface : bottomClass.getInterfaces()) {
            lineageClassList.addAll(ConfigUtils.getAllAnnotatedLineageClasses(superInterface, annotation));
        }
        return lineageClassList;
    }

    public static List<Member> getDeclaredMembers(Class<?> baseClass) {
        Stream<Field> fieldStream = Stream.of(baseClass.getDeclaredFields()).filter(field -> !field.isSynthetic()).sorted(alphabeticMemberComparator);
        Stream<Method> methodStream = Stream.of(baseClass.getDeclaredMethods()).filter(method -> !method.isSynthetic()).sorted(alphabeticMemberComparator);
        return Stream.concat(fieldStream, methodStream).collect(Collectors.toList());
    }

    public static List<Member> getAllMembers(Class<?> baseClass, Class<? extends Annotation> annotationClass) {
        Stream<Object> memberStream = Stream.empty();
        for (Class<?> clazz = baseClass; clazz != null; clazz = clazz.getSuperclass()) {
            Stream<Field> fieldStream = Stream.of(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(annotationClass) && !field.isSynthetic()).sorted(alphabeticMemberComparator);
            Stream<Method> methodStream = Stream.of(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotationClass) && !method.isSynthetic()).sorted(alphabeticMemberComparator);
            memberStream = Stream.concat(memberStream, Stream.concat(fieldStream, methodStream));
        }
        return memberStream.collect(Collectors.toList());
    }

    @SafeVarargs
    public static Class<? extends Annotation> extractAnnotationClass(Member member, Class<? extends Annotation> ... annotationClasses) {
        Class<? extends Annotation> annotationClass = null;
        for (Class<? extends Annotation> detectedAnnotationClass : annotationClasses) {
            if (!((AnnotatedElement)((Object)member)).isAnnotationPresent(detectedAnnotationClass)) continue;
            if (annotationClass != null) {
                throw new IllegalStateException("The class (" + member.getDeclaringClass() + ") has a member (" + member + ") that has both a " + annotationClass.getSimpleName() + " annotation and a " + detectedAnnotationClass.getSimpleName() + " annotation.");
            }
            annotationClass = detectedAnnotationClass;
        }
        return annotationClass;
    }

    public static Class<?> extractCollectionGenericTypeParameter(String parentClassConcept, Class<?> parentClass, Class<?> type, Type genericType, Class<? extends Annotation> annotationClass, String memberName) {
        if (!(genericType instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new IllegalArgumentException("The " + parentClassConcept + " (" + parentClass + ") has a " + (annotationClass == null ? "auto discovered" : annotationClass.getSimpleName() + " annotated") + " member (" + memberName + ") with a member type (" + type + ") which is parameterized collection with an unsupported number of generic parameters (" + typeArguments.length + ").");
        }
        Object typeArgument = typeArguments[0];
        if (typeArgument instanceof ParameterizedType) {
            typeArgument = ((ParameterizedType)typeArgument).getRawType();
        }
        if (typeArgument instanceof WildcardType) {
            Object[] upperBounds = ((WildcardType)typeArgument).getUpperBounds();
            if (upperBounds.length > 1) {
                throw new IllegalArgumentException("The " + parentClassConcept + " (" + parentClass + ") has a " + (annotationClass == null ? "auto discovered" : annotationClass.getSimpleName() + " annotated") + " member (" + memberName + ") with a member type (" + type + ") which is parameterized collection with a wildcard type argument (" + typeArgument + ") that has multiple upper bounds (" + Arrays.toString(upperBounds) + ").\nMaybe don't use wildcards with multiple upper bounds for the member (" + memberName + ").");
            }
            typeArgument = upperBounds.length == 0 ? Object.class : upperBounds[0];
        }
        if (!(typeArgument instanceof Class)) {
            return (Class)((ParameterizedType)typeArgument).getRawType();
        }
        return (Class)typeArgument;
    }

    public static <C> MemberAccessor findPlanningIdMemberAccessor(Class<C> clazz, DomainAccessType domainAccessType, Map<String, MemberAccessor> generatedMemberAccessorMap) {
        List<Member> memberList = ConfigUtils.getAllMembers(clazz, PlanningId.class);
        if (memberList.isEmpty()) {
            return null;
        }
        if (memberList.size() > 1) {
            throw new IllegalArgumentException("The class (" + clazz + ") has " + memberList.size() + " members (" + memberList + ") with a " + PlanningId.class.getSimpleName() + " annotation.");
        }
        Member member = memberList.get(0);
        MemberAccessor memberAccessor = MemberAccessorFactory.buildMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, PlanningId.class, domainAccessType, generatedMemberAccessorMap);
        if (!memberAccessor.getType().isPrimitive() && !Comparable.class.isAssignableFrom(memberAccessor.getType())) {
            throw new IllegalArgumentException("The class (" + clazz + ") has a member (" + member + ") with a @" + PlanningId.class.getSimpleName() + " annotation that returns a type (" + memberAccessor.getType() + ") that does not implement " + Comparable.class.getSimpleName() + ".\nMaybe use an " + Integer.class.getSimpleName() + " or " + String.class.getSimpleName() + " type instead.");
        }
        return memberAccessor;
    }

    public static String abbreviate(List<String> list, int limit) {
        String abbreviation = "";
        if (list != null) {
            abbreviation = list.stream().limit(limit).collect(Collectors.joining(", "));
            if (list.size() > limit) {
                abbreviation = abbreviation + ", ...";
            }
        }
        return abbreviation;
    }

    public static String abbreviate(List<String> list) {
        return ConfigUtils.abbreviate(list, 3);
    }

    private ConfigUtils() {
    }
}

