/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.swingui.realtime;

import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class AddProcessProblemFactChange
implements ProblemFactChange<CloudBalance> {
    private final CloudProcess process;

    public AddProcessProblemFactChange(CloudProcess process) {
        this.process = process;
    }

    public void doChange(ScoreDirector<CloudBalance> scoreDirector) {
        CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
        long nextProcessId = 0L;
        for (CloudProcess otherProcess : cloudBalance.getProcessList()) {
            if (nextProcessId > otherProcess.getId()) continue;
            nextProcessId = otherProcess.getId() + 1L;
        }
        this.process.setId(nextProcessId);
        scoreDirector.beforeEntityAdded((Object)this.process);
        cloudBalance.getProcessList().add(this.process);
        scoreDirector.afterEntityAdded((Object)this.process);
        scoreDirector.triggerVariableListeners();
    }
}

