/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.NavigableSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;

class SequenceImpl<ValueType_, DifferenceType_ extends Comparable<DifferenceType_>>
implements Sequence<ValueType_, DifferenceType_> {
    private final ConsecutiveSetTree<ValueType_, ?, DifferenceType_> sourceTree;
    private ValueType_ firstItem;
    private ValueType_ lastItem;
    private DifferenceType_ length;
    private NavigableSet<ValueType_> items;

    protected SequenceImpl(ConsecutiveSetTree<ValueType_, ?, DifferenceType_> sourceTree, ValueType_ item) {
        this(sourceTree, item, item);
    }

    protected SequenceImpl(ConsecutiveSetTree<ValueType_, ?, DifferenceType_> sourceTree, ValueType_ firstItem, ValueType_ lastItem) {
        this.sourceTree = sourceTree;
        this.firstItem = firstItem;
        this.lastItem = lastItem;
        this.length = null;
        this.items = null;
    }

    @Override
    public ValueType_ getFirstItem() {
        return this.firstItem;
    }

    @Override
    public ValueType_ getLastItem() {
        return this.lastItem;
    }

    @Override
    public NavigableSet<ValueType_> getItems() {
        if (this.items == null) {
            this.items = this.sourceTree.getItemSet().subSet(this.firstItem, true, this.lastItem, true);
            return this.items;
        }
        return this.items;
    }

    @Override
    public int getCount() {
        return this.getItems().size();
    }

    @Override
    public DifferenceType_ getLength() {
        if (this.length == null) {
            this.length = this.sourceTree.getSequenceLength(this);
            return this.length;
        }
        return this.length;
    }

    protected void setStart(ValueType_ item) {
        this.firstItem = item;
        this.invalidate();
    }

    protected void setEnd(ValueType_ item) {
        this.lastItem = item;
        this.invalidate();
    }

    protected void invalidate() {
        this.length = null;
        this.items = null;
    }

    protected SequenceImpl<ValueType_, DifferenceType_> split(ValueType_ fromElement) {
        ValueType_ newSequenceStart = this.sourceTree.getItemSet().higher(fromElement);
        ValueType_ newSequenceEnd = this.lastItem;
        this.lastItem = this.sourceTree.getItemSet().lower(fromElement);
        this.invalidate();
        return new SequenceImpl<ValueType_, DifferenceType_>(this.sourceTree, newSequenceStart, newSequenceEnd);
    }

    protected void merge(SequenceImpl<ValueType_, DifferenceType_> other) {
        this.lastItem = other.lastItem;
        this.invalidate();
    }

    public String toString() {
        return this.getItems().stream().map(Objects::toString).collect(Collectors.joining(", ", "Sequence [", "]"));
    }
}

