/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.memoryuse;

import java.util.List;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseMeasurement;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.AbstractSolver;

public class MemoryUseSubSingleStatistic<Solution_>
extends ProblemBasedSubSingleStatistic<Solution_, MemoryUseStatisticPoint> {
    private long timeMillisThresholdInterval;
    private MemoryUseSubSingleStatisticListener listener;

    public MemoryUseSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this(subSingleBenchmarkResult, 1000L);
    }

    public MemoryUseSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult, long timeMillisThresholdInterval) {
        super(subSingleBenchmarkResult, ProblemStatisticType.MEMORY_USE);
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
        this.listener = new MemoryUseSubSingleStatisticListener();
    }

    @Override
    public void open(Solver<Solution_> solver) {
        ((AbstractSolver)solver).addPhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver<Solution_> solver) {
        ((AbstractSolver)solver).removePhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return MemoryUseStatisticPoint.buildCsvLine("timeMillisSpent", "usedMemory", "maxMemory");
    }

    @Override
    protected MemoryUseStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new MemoryUseStatisticPoint(Long.parseLong(csvLine.get(0)), new MemoryUseMeasurement(Long.parseLong(csvLine.get(1)), Long.parseLong(csvLine.get(2))));
    }

    private class MemoryUseSubSingleStatisticListener
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private long nextTimeMillisThreshold;

        private MemoryUseSubSingleStatisticListener() {
            this.nextTimeMillisThreshold = MemoryUseSubSingleStatistic.this.timeMillisThresholdInterval;
        }

        public void stepEnded(AbstractStepScope<Solution_> stepScope) {
            long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow();
            if (timeMillisSpent >= this.nextTimeMillisThreshold) {
                MemoryUseSubSingleStatistic.this.pointList.add(new MemoryUseStatisticPoint(timeMillisSpent, MemoryUseMeasurement.create()));
                this.nextTimeMillisThreshold += MemoryUseSubSingleStatistic.this.timeMillisThresholdInterval;
                if (this.nextTimeMillisThreshold < timeMillisSpent) {
                    this.nextTimeMillisThreshold = timeMillisSpent;
                }
            }
        }
    }
}

