/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.manners2009.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhaseCommand;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.common.domain.PersistableIdComparator;
import org.optaplanner.examples.manners2009.domain.Guest;
import org.optaplanner.examples.manners2009.domain.Manners2009;
import org.optaplanner.examples.manners2009.domain.Seat;
import org.optaplanner.examples.manners2009.domain.SeatDesignation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manners2009SolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public void changeWorkingSolution(ScoreDirector scoreDirector) {
        Manners2009 manners2009 = (Manners2009)scoreDirector.getWorkingSolution();
        this.initializeSeatDesignationList(scoreDirector, manners2009);
    }

    private void initializeSeatDesignationList(ScoreDirector scoreDirector, Manners2009 manners2009) {
        List<SeatDesignation> seatDesignationList = this.createSeatDesignationList(manners2009);
        List<Seat> undesignatedSeatList = manners2009.getSeatList();
        for (SeatDesignation seatDesignation : seatDesignationList) {
            SimpleScore bestScore = SimpleScore.valueOf((int)Integer.MIN_VALUE);
            Seat bestSeat = null;
            boolean added = false;
            for (Seat seat : undesignatedSeatList) {
                Score score;
                if (seatDesignation.getGuest().getGender() != seat.getRequiredGender()) continue;
                if (!added) {
                    scoreDirector.beforeEntityAdded((Object)seatDesignation);
                    seatDesignation.setSeat(seat);
                    scoreDirector.afterEntityAdded((Object)seatDesignation);
                    added = true;
                } else {
                    scoreDirector.beforeVariableChanged((Object)seatDesignation, "seat");
                    seatDesignation.setSeat(seat);
                    scoreDirector.afterVariableChanged((Object)seatDesignation, "seat");
                }
                if ((score = scoreDirector.calculateScore()).compareTo((Object)bestScore) <= 0) continue;
                bestScore = score;
                bestSeat = seat;
            }
            if (bestSeat == null) {
                throw new IllegalStateException("The bestSeat (" + bestSeat + ") cannot be null.");
            }
            scoreDirector.beforeVariableChanged((Object)seatDesignation, "seat");
            seatDesignation.setSeat(bestSeat);
            scoreDirector.afterVariableChanged((Object)seatDesignation, "seat");
            undesignatedSeatList.remove(bestSeat);
        }
        Collections.sort(seatDesignationList, new PersistableIdComparator());
        manners2009.setSeatDesignationList(seatDesignationList);
    }

    private List<SeatDesignation> createSeatDesignationList(Manners2009 manners2009) {
        ArrayList<SeatDesignation> seatDesignationList = new ArrayList<SeatDesignation>(manners2009.getGuestList().size());
        for (Guest guest : manners2009.getGuestList()) {
            SeatDesignation seatDesignation = new SeatDesignation();
            seatDesignation.setId(guest.getId());
            seatDesignation.setGuest(guest);
            seatDesignationList.add(seatDesignation);
        }
        return seatDesignationList;
    }
}

