/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.solver.move.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactory;
import org.optaplanner.core.impl.move.CompositeMove;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.domain.solver.MovableShiftAssignmentSelectionFilter;
import org.optaplanner.examples.nurserostering.solver.move.EmployeeMultipleChangeMove;

public class ShiftAssignmentPillarPartSwapMoveFactory
implements MoveListFactory {
    private MovableShiftAssignmentSelectionFilter filter = new MovableShiftAssignmentSelectionFilter();

    public List<Move> createMoveList(Solution solution) {
        NurseRoster nurseRoster = (NurseRoster)solution;
        List<Employee> employeeList = nurseRoster.getEmployeeList();
        ArrayList<ShiftAssignment> shiftAssignmentList = new ArrayList<ShiftAssignment>(nurseRoster.getShiftAssignmentList());
        Iterator it = shiftAssignmentList.iterator();
        while (it.hasNext()) {
            ShiftAssignment shiftAssignment = (ShiftAssignment)it.next();
            if (this.filter.accept(nurseRoster, shiftAssignment)) continue;
            it.remove();
        }
        HashMap employeeToAssignmentSequenceListMap = new HashMap(employeeList.size());
        int assignmentSequenceCapacity = nurseRoster.getShiftDateList().size() + 0;
        for (Employee employee : employeeList) {
            employeeToAssignmentSequenceListMap.put(employee, new ArrayList(assignmentSequenceCapacity));
        }
        for (ShiftAssignment shiftAssignment : shiftAssignmentList) {
            Employee employee = shiftAssignment.getEmployee();
            List assignmentSequenceList = (List)employeeToAssignmentSequenceListMap.get(employee);
            if (assignmentSequenceList.isEmpty()) {
                AssignmentSequence assignmentSequence = new AssignmentSequence(employee, shiftAssignment);
                assignmentSequenceList.add(assignmentSequence);
                continue;
            }
            AssignmentSequence lastAssignmentSequence = (AssignmentSequence)assignmentSequenceList.get(assignmentSequenceList.size() - 1);
            if (lastAssignmentSequence.belongsHere(shiftAssignment)) {
                lastAssignmentSequence.add(shiftAssignment);
                continue;
            }
            AssignmentSequence assignmentSequence = new AssignmentSequence(employee, shiftAssignment);
            assignmentSequenceList.add(assignmentSequence);
        }
        ArrayList<Move> moveList = new ArrayList<Move>();
        ListIterator<Employee> leftEmployeeIt = employeeList.listIterator();
        while (leftEmployeeIt.hasNext()) {
            Employee leftEmployee = leftEmployeeIt.next();
            List leftAssignmentSequenceList = (List)employeeToAssignmentSequenceListMap.get(leftEmployee);
            ListIterator<Employee> rightEmployeeIt = employeeList.listIterator(leftEmployeeIt.nextIndex());
            while (rightEmployeeIt.hasNext()) {
                Employee rightEmployee = rightEmployeeIt.next();
                List rightAssignmentSequenceList = (List)employeeToAssignmentSequenceListMap.get(rightEmployee);
                LowestDayIndexAssignmentSequenceIterator lowestIt = new LowestDayIndexAssignmentSequenceIterator(leftAssignmentSequenceList, rightAssignmentSequenceList);
                while (lowestIt.hasNext()) {
                    Employee otherEmployee;
                    AssignmentSequence pillarPartAssignmentSequence = lowestIt.next();
                    ArrayList<EmployeeMultipleChangeMove> moveListByPillarPartDuo = new ArrayList<EmployeeMultipleChangeMove>(leftAssignmentSequenceList.size() + rightAssignmentSequenceList.size());
                    int lastDayIndex = pillarPartAssignmentSequence.getLastDayIndex();
                    int leftMinimumFirstDayIndex = Integer.MIN_VALUE;
                    int rightMinimumFirstDayIndex = Integer.MIN_VALUE;
                    if (lowestIt.isLastNextWasLeft()) {
                        otherEmployee = rightEmployee;
                        leftMinimumFirstDayIndex = lastDayIndex;
                    } else {
                        otherEmployee = leftEmployee;
                        rightMinimumFirstDayIndex = lastDayIndex;
                    }
                    moveListByPillarPartDuo.add(new EmployeeMultipleChangeMove(pillarPartAssignmentSequence.getEmployee(), pillarPartAssignmentSequence.getShiftAssignmentList(), otherEmployee));
                    while (lowestIt.hasNextWithMaximumFirstDayIndexes(leftMinimumFirstDayIndex, rightMinimumFirstDayIndex)) {
                        pillarPartAssignmentSequence = lowestIt.next();
                        lastDayIndex = pillarPartAssignmentSequence.getLastDayIndex();
                        if (lowestIt.isLastNextWasLeft()) {
                            otherEmployee = rightEmployee;
                            leftMinimumFirstDayIndex = Math.max(leftMinimumFirstDayIndex, lastDayIndex);
                        } else {
                            otherEmployee = leftEmployee;
                            rightMinimumFirstDayIndex = Math.max(rightMinimumFirstDayIndex, lastDayIndex);
                        }
                        moveListByPillarPartDuo.add(new EmployeeMultipleChangeMove(pillarPartAssignmentSequence.getEmployee(), pillarPartAssignmentSequence.getShiftAssignmentList(), otherEmployee));
                    }
                    moveList.add((Move)new CompositeMove(moveListByPillarPartDuo));
                }
            }
        }
        return moveList;
    }

    private static class LowestDayIndexAssignmentSequenceIterator
    implements Iterator<AssignmentSequence> {
        private Iterator<AssignmentSequence> leftIterator;
        private Iterator<AssignmentSequence> rightIterator;
        private boolean leftHasNext = true;
        private boolean rightHasNext = true;
        private AssignmentSequence nextLeft;
        private AssignmentSequence nextRight;
        private boolean lastNextWasLeft;

        public LowestDayIndexAssignmentSequenceIterator(List<AssignmentSequence> leftAssignmentList, List<AssignmentSequence> rightAssignmentList) {
            this.leftIterator = leftAssignmentList.iterator();
            if (this.leftIterator.hasNext()) {
                this.nextLeft = this.leftIterator.next();
            } else {
                this.leftHasNext = false;
                this.nextLeft = null;
            }
            this.rightIterator = rightAssignmentList.iterator();
            if (this.rightIterator.hasNext()) {
                this.nextRight = this.rightIterator.next();
            } else {
                this.rightHasNext = false;
                this.nextRight = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.leftHasNext || this.rightHasNext;
        }

        public boolean hasNextWithMaximumFirstDayIndexes(int leftMinimumFirstDayIndex, int rightMinimumFirstDayIndex) {
            if (!this.hasNext()) {
                return false;
            }
            boolean nextIsLeft = this.nextIsLeft();
            if (nextIsLeft) {
                int firstDayIndex = this.nextLeft.getFirstDayIndex();
                return firstDayIndex > leftMinimumFirstDayIndex && firstDayIndex <= rightMinimumFirstDayIndex;
            }
            int firstDayIndex = this.nextRight.getFirstDayIndex();
            return firstDayIndex > rightMinimumFirstDayIndex && firstDayIndex <= leftMinimumFirstDayIndex;
        }

        @Override
        public AssignmentSequence next() {
            AssignmentSequence lowest;
            this.lastNextWasLeft = this.nextIsLeft();
            if (this.lastNextWasLeft) {
                lowest = this.nextLeft;
                if (this.leftIterator.hasNext()) {
                    this.nextLeft = this.leftIterator.next();
                } else {
                    this.leftHasNext = false;
                    this.nextLeft = null;
                }
            } else {
                lowest = this.nextRight;
                if (this.rightIterator.hasNext()) {
                    this.nextRight = this.rightIterator.next();
                } else {
                    this.rightHasNext = false;
                    this.nextRight = null;
                }
            }
            return lowest;
        }

        private boolean nextIsLeft() {
            boolean returnLeft;
            if (this.leftHasNext) {
                int rightFirstDayIndex;
                int leftFirstDayIndex;
                returnLeft = this.rightHasNext ? (leftFirstDayIndex = this.nextLeft.getFirstDayIndex()) <= (rightFirstDayIndex = this.nextRight.getFirstDayIndex()) : true;
            } else if (this.rightHasNext) {
                returnLeft = false;
            } else {
                throw new NoSuchElementException();
            }
            return returnLeft;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        public boolean isLastNextWasLeft() {
            return this.lastNextWasLeft;
        }
    }

    private static class AssignmentSequence {
        private Employee employee;
        private List<ShiftAssignment> shiftAssignmentList;
        private int firstDayIndex;
        private int lastDayIndex;

        private AssignmentSequence(Employee employee, ShiftAssignment shiftAssignment) {
            this.employee = employee;
            this.shiftAssignmentList = new ArrayList<ShiftAssignment>();
            this.shiftAssignmentList.add(shiftAssignment);
            this.lastDayIndex = this.firstDayIndex = shiftAssignment.getShiftDateDayIndex();
        }

        public Employee getEmployee() {
            return this.employee;
        }

        public List<ShiftAssignment> getShiftAssignmentList() {
            return this.shiftAssignmentList;
        }

        public int getFirstDayIndex() {
            return this.firstDayIndex;
        }

        public int getLastDayIndex() {
            return this.lastDayIndex;
        }

        private void add(ShiftAssignment shiftAssignment) {
            this.shiftAssignmentList.add(shiftAssignment);
            int dayIndex = shiftAssignment.getShiftDateDayIndex();
            if (dayIndex < this.lastDayIndex) {
                throw new IllegalStateException("The shiftAssignmentList is expected to be sorted by shiftDate.");
            }
            this.lastDayIndex = dayIndex;
        }

        private boolean belongsHere(ShiftAssignment shiftAssignment) {
            return shiftAssignment.getShiftDateDayIndex() <= this.lastDayIndex + 1;
        }
    }
}

