/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.solver.move;

import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.Room;

public class ExaminationMoveHelper {
    public static void movePeriod(ScoreDirector scoreDirector, Exam exam, Period period) {
        scoreDirector.beforeVariableChanged((Object)exam, "period");
        exam.setPeriod(period);
        scoreDirector.afterVariableChanged((Object)exam, "period");
        ExaminationMoveHelper.movePeriodCoincidence(scoreDirector, exam, period);
    }

    public static void moveRoom(ScoreDirector scoreDirector, Exam exam, Room room) {
        scoreDirector.beforeVariableChanged((Object)exam, "room");
        exam.setRoom(room);
        scoreDirector.afterVariableChanged((Object)exam, "room");
    }

    public static void moveExam(ScoreDirector scoreDirector, Exam exam, Period period, Room room) {
        scoreDirector.beforeAllVariablesChanged((Object)exam);
        exam.setPeriod(period);
        exam.setRoom(room);
        scoreDirector.afterAllVariablesChanged((Object)exam);
        ExaminationMoveHelper.movePeriodCoincidence(scoreDirector, exam, period);
    }

    public static void movePeriodCoincidence(ScoreDirector scoreDirector, Exam exam, Period period) {
        if (exam.getExamCoincidence() != null) {
            for (Exam coincidenceExam : exam.getExamCoincidence().getCoincidenceExamSet()) {
                if (exam.equals(coincidenceExam)) continue;
                scoreDirector.beforeVariableChanged((Object)coincidenceExam, "period");
                coincidenceExam.setPeriod(period);
                scoreDirector.afterVariableChanged((Object)coincidenceExam, "period");
            }
        }
    }

    private ExaminationMoveHelper() {
    }
}

