/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhaseCommand;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.common.domain.PersistableIdComparator;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.PeriodPenalty;
import org.optaplanner.examples.examination.domain.PeriodPenaltyType;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.Topic;
import org.optaplanner.examples.examination.domain.solver.ExamBefore;
import org.optaplanner.examples.examination.domain.solver.ExamCoincidence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExaminationSolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public void changeWorkingSolution(ScoreDirector scoreDirector) {
        Examination examination = (Examination)scoreDirector.getWorkingSolution();
        this.initializeExamList(scoreDirector, examination);
    }

    private void initializeExamList(ScoreDirector scoreDirector, Examination examination) {
        List<Period> periodList = examination.getPeriodList();
        List<Room> roomList = examination.getRoomList();
        ArrayList<Exam> examList = new ArrayList<Exam>(examination.getTopicList().size());
        List<ExamInitializationWeight> examInitialWeightList = this.createExamAssigningScoreList(examination);
        for (ExamInitializationWeight examInitialWeight : examInitialWeightList) {
            Score unscheduledScore = scoreDirector.calculateScore();
            Exam leader = examInitialWeight.getExam();
            ArrayList<ExamToHandle> examToHandleList = new ArrayList<ExamToHandle>(5);
            if (leader.getExamCoincidence() == null) {
                examToHandleList.add(new ExamToHandle(leader));
            } else {
                for (Exam coincidenceExam : leader.getExamCoincidence().getCoincidenceExamSet()) {
                    examToHandleList.add(new ExamToHandle(coincidenceExam));
                }
            }
            ArrayList<PeriodScoring> periodScoringList = new ArrayList<PeriodScoring>(periodList.size());
            for (Period period : periodList) {
                for (ExamToHandle examToHandle : examToHandleList) {
                    Exam exam = examToHandle.getExam();
                    if (!examToHandle.isAdded()) {
                        scoreDirector.beforeEntityAdded((Object)exam);
                        exam.setPeriod(period);
                        scoreDirector.afterEntityAdded((Object)exam);
                        examToHandle.setAdded(true);
                        continue;
                    }
                    scoreDirector.beforeVariableChanged((Object)exam, "period");
                    exam.setPeriod(period);
                    scoreDirector.afterVariableChanged((Object)exam, "period");
                }
                Score score = scoreDirector.calculateScore();
                periodScoringList.add(new PeriodScoring(period, score));
            }
            Collections.sort(periodScoringList);
            this.scheduleLeader(periodScoringList, roomList, scoreDirector, unscheduledScore, examToHandleList, leader);
            examList.add(leader);
            for (ExamToHandle examToHandle : examToHandleList) {
                Exam exam = examToHandle.getExam();
                if (exam.isCoincidenceLeader()) continue;
                this.scheduleNonLeader(roomList, scoreDirector, exam);
                examList.add(exam);
            }
        }
        Collections.sort(examList, new PersistableIdComparator());
        examination.setExamList(examList);
    }

    private void scheduleLeader(List<PeriodScoring> periodScoringList, List<Room> roomList, ScoreDirector scoreDirector, Score unscheduledScore, List<ExamToHandle> examToHandleList, Exam leader) {
        boolean perfectMatch = false;
        HardSoftScore bestScore = HardSoftScore.valueOf((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
        Period bestPeriod = null;
        Room bestRoom = null;
        for (PeriodScoring periodScoring : periodScoringList) {
            if (bestScore.compareTo((Object)periodScoring.getScore()) >= 0) break;
            for (ExamToHandle examToHandle : examToHandleList) {
                Exam exam = examToHandle.getExam();
                scoreDirector.beforeVariableChanged((Object)exam, "period");
                exam.setPeriod(periodScoring.getPeriod());
                scoreDirector.afterVariableChanged((Object)exam, "period");
            }
            for (Room room : roomList) {
                scoreDirector.beforeVariableChanged((Object)leader, "room");
                leader.setRoom(room);
                scoreDirector.afterVariableChanged((Object)leader, "room");
                Score score = scoreDirector.calculateScore();
                if (score.compareTo((Object)unscheduledScore) < 0) {
                    if (score.compareTo((Object)bestScore) <= 0) continue;
                    bestScore = score;
                    bestPeriod = periodScoring.getPeriod();
                    bestRoom = room;
                    continue;
                }
                if (score.equals(unscheduledScore)) {
                    perfectMatch = true;
                    break;
                }
                throw new IllegalStateException("The score (" + score + ") cannot be higher than unscheduledScore (" + unscheduledScore + ").");
            }
            if (!perfectMatch) continue;
            break;
        }
        if (!perfectMatch) {
            if (bestPeriod == null || bestRoom == null) {
                throw new IllegalStateException("The bestPeriod (" + bestPeriod + ") or the bestRoom (" + bestRoom + ") cannot be null.");
            }
            scoreDirector.beforeVariableChanged((Object)leader, "room");
            leader.setRoom(bestRoom);
            scoreDirector.afterVariableChanged((Object)leader, "room");
            for (ExamToHandle examToHandle : examToHandleList) {
                Exam exam = examToHandle.getExam();
                scoreDirector.beforeVariableChanged((Object)exam, "period");
                exam.setPeriod(bestPeriod);
                scoreDirector.afterVariableChanged((Object)exam, "period");
            }
        }
        this.logger.debug("    Exam ({}) initialized.", (Object)leader);
    }

    private void scheduleNonLeader(List<Room> roomList, ScoreDirector scoreDirector, Exam exam) {
        if (exam.getRoom() != null) {
            throw new IllegalStateException("Exam (" + exam + ") already has a room.");
        }
        Score unscheduledScore = scoreDirector.calculateScore();
        boolean perfectMatch = false;
        HardSoftScore bestScore = HardSoftScore.valueOf((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
        Room bestRoom = null;
        for (Room room : roomList) {
            scoreDirector.beforeVariableChanged((Object)exam, "room");
            exam.setRoom(room);
            scoreDirector.afterVariableChanged((Object)exam, "room");
            Score score = scoreDirector.calculateScore();
            if (score.compareTo((Object)unscheduledScore) < 0) {
                if (score.compareTo((Object)bestScore) <= 0) continue;
                bestScore = score;
                bestRoom = room;
                continue;
            }
            if (score.equals(unscheduledScore)) {
                perfectMatch = true;
                break;
            }
            throw new IllegalStateException("The score (" + score + ") cannot be higher than unscheduledScore (" + unscheduledScore + ").");
        }
        if (!perfectMatch) {
            if (bestRoom == null) {
                throw new IllegalStateException("The bestRoom (" + bestRoom + ") cannot be null.");
            }
            scoreDirector.beforeVariableChanged((Object)exam, "room");
            exam.setRoom(bestRoom);
            scoreDirector.afterVariableChanged((Object)exam, "room");
        }
        this.logger.debug("    Exam ({}) initialized.", (Object)exam);
    }

    private List<ExamInitializationWeight> createExamAssigningScoreList(Examination examination) {
        List<Exam> examList = this.createExamList(examination);
        ArrayList<ExamInitializationWeight> examInitialWeightList = new ArrayList<ExamInitializationWeight>(examList.size());
        for (Exam exam : examList) {
            if (exam.getPeriod() != null && exam.getRoom() != null || !exam.isCoincidenceLeader()) continue;
            examInitialWeightList.add(new ExamInitializationWeight(exam));
        }
        Collections.sort(examInitialWeightList);
        return examInitialWeightList;
    }

    public List<Exam> createExamList(Examination examination) {
        List<Topic> topicList = examination.getTopicList();
        List<Exam> examList = examination.getExamList();
        HashMap<Topic, Exam> topicToExamMap = new HashMap<Topic, Exam>(topicList.size());
        for (Exam exam : examList) {
            topicToExamMap.put(exam.getTopic(), exam);
        }
        for (PeriodPenalty periodPenalty : examination.getPeriodPenaltyList()) {
            if (periodPenalty.getPeriodPenaltyType() == PeriodPenaltyType.EXAM_COINCIDENCE) {
                Exam leftExam = (Exam)topicToExamMap.get(periodPenalty.getLeftSideTopic());
                Exam rightExam = (Exam)topicToExamMap.get(periodPenalty.getRightSideTopic());
                LinkedHashSet<Exam> newCoincidenceExamSet = new LinkedHashSet<Exam>(4);
                ExamCoincidence leftExamCoincidence = leftExam.getExamCoincidence();
                if (leftExamCoincidence != null) {
                    newCoincidenceExamSet.addAll(leftExamCoincidence.getCoincidenceExamSet());
                } else {
                    newCoincidenceExamSet.add(leftExam);
                }
                ExamCoincidence rightExamCoincidence = rightExam.getExamCoincidence();
                if (rightExamCoincidence != null) {
                    newCoincidenceExamSet.addAll(rightExamCoincidence.getCoincidenceExamSet());
                } else {
                    newCoincidenceExamSet.add(rightExam);
                }
                ExamCoincidence newExamCoincidence = new ExamCoincidence(newCoincidenceExamSet);
                for (Exam exam : newCoincidenceExamSet) {
                    exam.setExamCoincidence(newExamCoincidence);
                }
                continue;
            }
            if (periodPenalty.getPeriodPenaltyType() != PeriodPenaltyType.AFTER) continue;
            Exam afterExam = (Exam)topicToExamMap.get(periodPenalty.getLeftSideTopic());
            Exam beforeExam = (Exam)topicToExamMap.get(periodPenalty.getRightSideTopic());
            ExamBefore examBefore = beforeExam.getExamBefore();
            if (examBefore == null) {
                examBefore = new ExamBefore(new LinkedHashSet<Exam>(2));
                beforeExam.setExamBefore(examBefore);
            }
            examBefore.getAfterExamSet().add(afterExam);
        }
        return examList;
    }

    private static class PeriodScoring
    implements Comparable<PeriodScoring> {
        private Period period;
        private Score score;

        private PeriodScoring(Period period, Score score) {
            this.period = period;
            this.score = score;
        }

        public Period getPeriod() {
            return this.period;
        }

        public Score getScore() {
            return this.score;
        }

        @Override
        public int compareTo(PeriodScoring other) {
            return -new CompareToBuilder().append((Object)this.score, (Object)other.score).toComparison();
        }
    }

    private static class ExamInitializationWeight
    implements Comparable<ExamInitializationWeight> {
        private Exam exam;
        private int totalStudentSize;
        private int maximumDuration;

        private ExamInitializationWeight(Exam exam) {
            this.exam = exam;
            this.totalStudentSize = this.calculateTotalStudentSize(exam);
            this.maximumDuration = this.calculateMaximumDuration(exam);
        }

        private int calculateTotalStudentSize(Exam innerExam) {
            int innerTotalStudentSize = 0;
            if (innerExam.getExamCoincidence() == null) {
                innerTotalStudentSize = innerExam.getTopicStudentSize();
            } else {
                for (Exam coincidenceExam : innerExam.getExamCoincidence().getCoincidenceExamSet()) {
                    innerTotalStudentSize += coincidenceExam.getTopicStudentSize();
                }
            }
            if (innerExam.getExamBefore() != null) {
                for (Exam afterExam : innerExam.getExamBefore().getAfterExamSet()) {
                    innerTotalStudentSize += this.calculateTotalStudentSize(afterExam);
                }
            }
            return innerTotalStudentSize;
        }

        private int calculateMaximumDuration(Exam innerExam) {
            int innerMaximumDuration = innerExam.getTopic().getDuration();
            if (innerExam.getExamCoincidence() != null) {
                for (Exam coincidenceExam : innerExam.getExamCoincidence().getCoincidenceExamSet()) {
                    innerMaximumDuration = Math.max(innerMaximumDuration, coincidenceExam.getTopicStudentSize());
                }
            }
            if (innerExam.getExamBefore() != null) {
                for (Exam afterExam : innerExam.getExamBefore().getAfterExamSet()) {
                    innerMaximumDuration = Math.max(innerMaximumDuration, this.calculateMaximumDuration(afterExam));
                }
            }
            return innerMaximumDuration;
        }

        public Exam getExam() {
            return this.exam;
        }

        @Override
        public int compareTo(ExamInitializationWeight other) {
            return new CompareToBuilder().append(other.totalStudentSize, this.totalStudentSize).append(other.maximumDuration, this.maximumDuration).append((Object)this.exam.getId(), (Object)other.exam.getId()).toComparison();
        }
    }

    public static class ExamToHandle {
        private Exam exam;
        private boolean added = true;

        public ExamToHandle(Exam exam) {
            this.exam = exam;
        }

        public Exam getExam() {
            return this.exam;
        }

        public boolean isAdded() {
            return this.added;
        }

        public void setAdded(boolean added) {
            this.added = added;
        }
    }
}

