/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.SolutionFileFilter;
import org.optaplanner.examples.common.persistence.SolutionDao;

@RunWith(value=Parameterized.class)
public abstract class SolutionDaoTest
extends LoggingTest {
    protected SolutionDao solutionDao;
    protected File solutionFile;

    protected static Collection<Object[]> getSolutionFilesAsParameters(SolutionDao solutionDao) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        File dataDir = solutionDao.getDataDir();
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        List<File> unsolvedFileList = Arrays.asList(unsolvedDataDir.listFiles((FileFilter)new SolutionFileFilter(solutionDao)));
        Collections.sort(unsolvedFileList);
        for (File unsolvedFile : unsolvedFileList) {
            filesAsParameters.add(new Object[]{unsolvedFile});
        }
        File solvedDataDir = new File(dataDir, "solved");
        if (solvedDataDir.exists()) {
            List<File> solvedFileList = Arrays.asList(solvedDataDir.listFiles((FileFilter)new SolutionFileFilter(solutionDao)));
            Collections.sort(solvedFileList);
            for (File solvedFile : solvedFileList) {
                filesAsParameters.add(new Object[]{solvedFile});
            }
        }
        return filesAsParameters;
    }

    protected SolutionDaoTest(File solutionFile) {
        this.solutionFile = solutionFile;
    }

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
        File dataDir = this.solutionDao.getDataDir();
        if (!dataDir.exists()) {
            throw new IllegalStateException("The directory dataDir (" + dataDir.getAbsolutePath() + ") does not exist." + " The working directory should be set to the directory that contains the data directory." + " This is different in a git clone (optaplanner/optaplanner-examples)" + " and the release zip (examples).");
        }
    }

    protected abstract SolutionDao createSolutionDao();

    @Test
    public void readSolution() {
        this.solutionDao.readSolution(this.solutionFile);
    }
}

